<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for ParcelShopType StructType
 * Meta information extracted from the WSDL
 * - documentation: includes | Type of ParcelShop (Receiver is in Europe)
 * @subpackage Structs
 */
class ParcelShopType extends AbstractStructBase
{
    /**
     * The parcelShopNumber
     * Meta information extracted from the WSDL
     * - documentation: Number of the ParcelShop
     * - base: xs:string
     * - maxLength: 3
     * - minLength: 3
     * @var string
     */
    public $parcelShopNumber;
    /**
     * The streetName
     * Meta information extracted from the WSDL
     * - documentation: The name of the street. Optionally the house number can be passed in this field too. In this case the field "streetNumber" must not be present. | Name of street of the ParcelShop
     * - base: xs:string
     * - maxLength: 35
     * - minOccurs: 0
     * @var string
     */
    public $streetName;
    /**
     * The streetNumber
     * Meta information extracted from the WSDL
     * - documentation: The house number. This field is only optional when the house number is passed with the field streetName. | House number of the ParcelShop
     * - base: xs:string
     * - maxLength: 5
     * - minOccurs: 0
     * @var string
     */
    public $streetNumber;
    /**
     * The zip
     * Meta information extracted from the WSDL
     * - documentation: Type of zip code
     * - base: xs:string
     * - maxLength: 17
     * - ref: cis:zip
     * @var string
     */
    public $zip;
    /**
     * The city
     * Meta information extracted from the WSDL
     * - documentation: City name.
     * - base: xs:string
     * - maxLength: 50
     * - ref: cis:city
     * @var string
     */
    public $city;
    /**
     * The Origin
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - ref: cis:Origin
     * @var \StructType\CountryType
     */
    public $Origin;
    /**
     * The ParcelShopNumber
     * Meta information extracted from the WSDL
     * - documentation: Number of the ParcelShop
     * @var string
     */
    public $ParcelShopNumber;
    /**
     * The Zip
     * Meta information extracted from the WSDL
     * - documentation: Postcode
     * - base: xs:string
     * - maxLength: 5
     * - minLength: 5
     * - pattern: [0-9]{5}
     * @var string
     */
    public $Zip;
    /**
     * The City
     * Meta information extracted from the WSDL
     * - documentation: City name.
     * - base: xs:string
     * - maxLength: 50
     * @var string
     */
    public $City;
    /**
     * Constructor method for ParcelShopType
     * @uses ParcelShopType::setParcelShopNumber()
     * @uses ParcelShopType::setStreetName()
     * @uses ParcelShopType::setStreetNumber()
     * @uses ParcelShopType::setZip()
     * @uses ParcelShopType::setCity()
     * @uses ParcelShopType::setOrigin()
     * @uses ParcelShopType::setParcelShopNumber_1()
     * @uses ParcelShopType::setZip_1()
     * @uses ParcelShopType::setCity_1()
     * @param string $parcelShopNumber
     * @param string $streetName
     * @param string $streetNumber
     * @param string $zip
     * @param string $city
     * @param \StructType\CountryType $origin
     * @param string $parcelShopNumber
     * @param string $zip
     * @param string $city
     */
    public function __construct($parcelShopNumber = null, $streetName = null, $streetNumber = null, $zip = null, $city = null, \StructType\CountryType $origin = null, $parcelShopNumber_1 = null, $zip_1 = null, $city_1 = null)
    {
        $this
            ->setParcelShopNumber($parcelShopNumber)
            ->setStreetName($streetName)
            ->setStreetNumber($streetNumber)
            ->setZip($zip)
            ->setCity($city)
            ->setOrigin($origin)
            ->setParcelShopNumber_1($parcelShopNumber_1)
            ->setZip_1($zip_1)
            ->setCity_1($city_1);
    }
    /**
     * Get ParcelShopNumber value
     * @return string|null
     */
    public function getParcelShopNumber()
    {
        return $this->parcelShopNumber;
    }
    /**
     * Set ParcelShopNumber value
     * @param string $parcelShopNumber
     * @return \StructType\ParcelShopType
     */
    public function setParcelShopNumber($parcelShopNumber = null)
    {
        // validation for constraint: string
        if (!is_null($parcelShopNumber) && !is_string($parcelShopNumber)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($parcelShopNumber, true), gettype($parcelShopNumber)), __LINE__);
        }
        // validation for constraint: maxLength(3)
        if (!is_null($parcelShopNumber) && mb_strlen($parcelShopNumber) > 3) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be less than or equal to 3', mb_strlen($parcelShopNumber)), __LINE__);
        }
        // validation for constraint: minLength(3)
        if (!is_null($parcelShopNumber) && mb_strlen($parcelShopNumber) < 3) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be greater than or equal to 3', mb_strlen($parcelShopNumber)), __LINE__);
        }
        $this->parcelShopNumber = $parcelShopNumber;
        return $this;
    }
    /**
     * Get streetName value
     * @return string|null
     */
    public function getStreetName()
    {
        return $this->streetName;
    }
    /**
     * Set streetName value
     * @param string $streetName
     * @return \StructType\ParcelShopType
     */
    public function setStreetName($streetName = null)
    {
        // validation for constraint: string
        if (!is_null($streetName) && !is_string($streetName)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($streetName, true), gettype($streetName)), __LINE__);
        }
        // validation for constraint: maxLength(35)
        if (!is_null($streetName) && mb_strlen($streetName) > 35) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be less than or equal to 35', mb_strlen($streetName)), __LINE__);
        }
        $this->streetName = $streetName;
        return $this;
    }
    /**
     * Get streetNumber value
     * @return string|null
     */
    public function getStreetNumber()
    {
        return $this->streetNumber;
    }
    /**
     * Set streetNumber value
     * @param string $streetNumber
     * @return \StructType\ParcelShopType
     */
    public function setStreetNumber($streetNumber = null)
    {
        // validation for constraint: string
        if (!is_null($streetNumber) && !is_string($streetNumber)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($streetNumber, true), gettype($streetNumber)), __LINE__);
        }
        // validation for constraint: maxLength(5)
        if (!is_null($streetNumber) && mb_strlen($streetNumber) > 5) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be less than or equal to 5', mb_strlen($streetNumber)), __LINE__);
        }
        $this->streetNumber = $streetNumber;
        return $this;
    }
    /**
     * Get Zip value
     * @return string|null
     */
    public function getZip()
    {
        return $this->zip;
    }
    /**
     * Set Zip value
     * @param string $zip
     * @return \StructType\ParcelShopType
     */
    public function setZip($zip = null)
    {
        // validation for constraint: string
        if (!is_null($zip) && !is_string($zip)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($zip, true), gettype($zip)), __LINE__);
        }
        // validation for constraint: maxLength(17)
        if (!is_null($zip) && mb_strlen($zip) > 17) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be less than or equal to 17', mb_strlen($zip)), __LINE__);
        }
        $this->zip = $zip;
        return $this;
    }
    /**
     * Get City value
     * @return string|null
     */
    public function getCity()
    {
        return $this->city;
    }
    /**
     * Set City value
     * @param string $city
     * @return \StructType\ParcelShopType
     */
    public function setCity($city = null)
    {
        // validation for constraint: string
        if (!is_null($city) && !is_string($city)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($city, true), gettype($city)), __LINE__);
        }
        // validation for constraint: maxLength(50)
        if (!is_null($city) && mb_strlen($city) > 50) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be less than or equal to 50', mb_strlen($city)), __LINE__);
        }
        $this->city = $city;
        return $this;
    }
    /**
     * Get Origin value
     * @return \StructType\CountryType|null
     */
    public function getOrigin()
    {
        return $this->Origin;
    }
    /**
     * Set Origin value
     * @param \StructType\CountryType $origin
     * @return \StructType\ParcelShopType
     */
    public function setOrigin(\StructType\CountryType $origin = null)
    {
        $this->Origin = $origin;
        return $this;
    }
    /**
     * Get ParcelShopNumber value
     * @return string|null
     */
    public function getParcelShopNumber_1()
    {
        return $this->ParcelShopNumber;
    }
    /**
     * Set ParcelShopNumber value
     * @param string $parcelShopNumber
     * @return \StructType\ParcelShopType
     */
    public function setParcelShopNumber_1($parcelShopNumber_1 = null)
    {
        // validation for constraint: string
        if (!is_null($parcelShopNumber_1) && !is_string($parcelShopNumber_1)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($parcelShopNumber_1, true), gettype($parcelShopNumber_1)), __LINE__);
        }
        $this->ParcelShopNumber = $parcelShopNumber_1;
        return $this;
    }
    /**
     * Get Zip value
     * @return string|null
     */
    public function getZip_1()
    {
        return $this->Zip;
    }
    /**
     * Set Zip value
     * @param string $zip
     * @return \StructType\ParcelShopType
     */
    public function setZip_1($zip_1 = null)
    {
        // validation for constraint: string
        if (!is_null($zip_1) && !is_string($zip_1)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($zip_1, true), gettype($zip_1)), __LINE__);
        }
        // validation for constraint: maxLength(5)
        if (!is_null($zip_1) && mb_strlen($zip_1) > 5) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be less than or equal to 5', mb_strlen($zip_1)), __LINE__);
        }
        // validation for constraint: minLength(5)
        if (!is_null($zip_1) && mb_strlen($zip_1) < 5) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be greater than or equal to 5', mb_strlen($zip_1)), __LINE__);
        }
        // validation for constraint: pattern([0-9]{5})
        if (!is_null($zip_1) && !preg_match('/[0-9]{5}/', $zip_1)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression [0-9]{5}', var_export($zip_1, true)), __LINE__);
        }
        $this->Zip = $zip_1;
        return $this;
    }
    /**
     * Get City value
     * @return string|null
     */
    public function getCity_1()
    {
        return $this->City;
    }
    /**
     * Set City value
     * @param string $city
     * @return \StructType\ParcelShopType
     */
    public function setCity_1($city_1 = null)
    {
        // validation for constraint: string
        if (!is_null($city_1) && !is_string($city_1)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($city_1, true), gettype($city_1)), __LINE__);
        }
        // validation for constraint: maxLength(50)
        if (!is_null($city_1) && mb_strlen($city_1) > 50) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be less than or equal to 50', mb_strlen($city_1)), __LINE__);
        }
        $this->City = $city_1;
        return $this;
    }
}
