<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for PackStationType StructType
 * Meta information extracted from the WSDL
 * - documentation: includes | Type of packstation.
 * @subpackage Structs
 */
class PackStationType extends AbstractStructBase
{
    /**
     * The postNumber
     * Meta information extracted from the WSDL
     * - documentation: Post Nummer of the receiver, if not set receiver e-mail and/or mobilephone number needs to be set. When sending to a packstation with "DHL Paket" (V01PAK), the postnumber must always be entered. | Post Nummer of the receiver | Post
     * Nummer of the receiver or receiver e-mail-adress.
     * - base: xs:string
     * - maxLength: 10
     * - minLength: 1
     * @var string
     */
    public $postNumber;
    /**
     * The packstationNumber
     * Meta information extracted from the WSDL
     * - documentation: Number of the Packstation.
     * - base: xs:string
     * - maxLength: 3
     * - minLength: 3
     * @var string
     */
    public $packstationNumber;
    /**
     * The zip
     * Meta information extracted from the WSDL
     * - documentation: Type of zip code
     * - base: xs:string
     * - maxLength: 17
     * - ref: cis:zip
     * @var string
     */
    public $zip;
    /**
     * The city
     * Meta information extracted from the WSDL
     * - documentation: City name.
     * - base: xs:string
     * - maxLength: 50
     * - ref: cis:city
     * @var string
     */
    public $city;
    /**
     * The province
     * Meta information extracted from the WSDL
     * - documentation: Province name.
     * - base: xs:string
     * - maxLength: 35
     * - minOccurs: 0
     * - ref: cis:province
     * @var string
     */
    public $province;
    /**
     * The Origin
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - ref: cis:Origin
     * @var \StructType\CountryType
     */
    public $Origin;
    /**
     * Constructor method for PackStationType
     * @uses PackStationType::setPostNumber()
     * @uses PackStationType::setPackstationNumber()
     * @uses PackStationType::setZip()
     * @uses PackStationType::setCity()
     * @uses PackStationType::setProvince()
     * @uses PackStationType::setOrigin()
     * @param string $postNumber
     * @param string $packstationNumber
     * @param string $zip
     * @param string $city
     * @param string $province
     * @param \StructType\CountryType $origin
     */
    public function __construct($postNumber = null, $packstationNumber = null, $zip = null, $city = null, $province = null, \StructType\CountryType $origin = null)
    {
        $this
            ->setPostNumber($postNumber)
            ->setPackstationNumber($packstationNumber)
            ->setZip($zip)
            ->setCity($city)
            ->setProvince($province)
            ->setOrigin($origin);
    }
    /**
     * Get postNumber value
     * @return string|null
     */
    public function getPostNumber()
    {
        return $this->postNumber;
    }
    /**
     * Set postNumber value
     * @param string $postNumber
     * @return \StructType\PackStationType
     */
    public function setPostNumber($postNumber = null)
    {
        // validation for constraint: string
        if (!is_null($postNumber) && !is_string($postNumber)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($postNumber, true), gettype($postNumber)), __LINE__);
        }
        // validation for constraint: maxLength(10)
        if (!is_null($postNumber) && mb_strlen($postNumber) > 10) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be less than or equal to 10', mb_strlen($postNumber)), __LINE__);
        }
        // validation for constraint: minLength(1)
        if (!is_null($postNumber) && mb_strlen($postNumber) < 1) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be greater than or equal to 1', mb_strlen($postNumber)), __LINE__);
        }
        $this->postNumber = $postNumber;
        return $this;
    }
    /**
     * Get packstationNumber value
     * @return string|null
     */
    public function getPackstationNumber()
    {
        return $this->packstationNumber;
    }
    /**
     * Set packstationNumber value
     * @param string $packstationNumber
     * @return \StructType\PackStationType
     */
    public function setPackstationNumber($packstationNumber = null)
    {
        // validation for constraint: string
        if (!is_null($packstationNumber) && !is_string($packstationNumber)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($packstationNumber, true), gettype($packstationNumber)), __LINE__);
        }
        // validation for constraint: maxLength(3)
        if (!is_null($packstationNumber) && mb_strlen($packstationNumber) > 3) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be less than or equal to 3', mb_strlen($packstationNumber)), __LINE__);
        }
        // validation for constraint: minLength(3)
        if (!is_null($packstationNumber) && mb_strlen($packstationNumber) < 3) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be greater than or equal to 3', mb_strlen($packstationNumber)), __LINE__);
        }
        $this->packstationNumber = $packstationNumber;
        return $this;
    }
    /**
     * Get zip value
     * @return string|null
     */
    public function getZip()
    {
        return $this->zip;
    }
    /**
     * Set zip value
     * @param string $zip
     * @return \StructType\PackStationType
     */
    public function setZip($zip = null)
    {
        // validation for constraint: string
        if (!is_null($zip) && !is_string($zip)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($zip, true), gettype($zip)), __LINE__);
        }
        // validation for constraint: maxLength(17)
        if (!is_null($zip) && mb_strlen($zip) > 17) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be less than or equal to 17', mb_strlen($zip)), __LINE__);
        }
        $this->zip = $zip;
        return $this;
    }
    /**
     * Get city value
     * @return string|null
     */
    public function getCity()
    {
        return $this->city;
    }
    /**
     * Set city value
     * @param string $city
     * @return \StructType\PackStationType
     */
    public function setCity($city = null)
    {
        // validation for constraint: string
        if (!is_null($city) && !is_string($city)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($city, true), gettype($city)), __LINE__);
        }
        // validation for constraint: maxLength(50)
        if (!is_null($city) && mb_strlen($city) > 50) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be less than or equal to 50', mb_strlen($city)), __LINE__);
        }
        $this->city = $city;
        return $this;
    }
    /**
     * Get province value
     * @return string|null
     */
    public function getProvince()
    {
        return $this->province;
    }
    /**
     * Set province value
     * @param string $province
     * @return \StructType\PackStationType
     */
    public function setProvince($province = null)
    {
        // validation for constraint: string
        if (!is_null($province) && !is_string($province)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($province, true), gettype($province)), __LINE__);
        }
        // validation for constraint: maxLength(35)
        if (!is_null($province) && mb_strlen($province) > 35) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be less than or equal to 35', mb_strlen($province)), __LINE__);
        }
        $this->province = $province;
        return $this;
    }
    /**
     * Get Origin value
     * @return \StructType\CountryType|null
     */
    public function getOrigin()
    {
        return $this->Origin;
    }
    /**
     * Set Origin value
     * @param \StructType\CountryType $origin
     * @return \StructType\PackStationType
     */
    public function setOrigin(\StructType\CountryType $origin = null)
    {
        $this->Origin = $origin;
        return $this;
    }
}
