<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for IdentityData StructType
 * Meta information extracted from the WSDL
 * - documentation: Identity data (used e.g. for ident services)
 * @subpackage Structs
 */
class IdentityData extends AbstractStructBase
{
    /**
     * The DrivingLicense
     * Meta information extracted from the WSDL
     * - choice: DrivingLicense | IdentityCard | BankCard
     * - choiceMaxOccurs: 1
     * - choiceMinOccurs: 1
     * @var \StructType\DrivingLicense
     */
    public $DrivingLicense;
    /**
     * The IdentityCard
     * Meta information extracted from the WSDL
     * - choice: DrivingLicense | IdentityCard | BankCard
     * - choiceMaxOccurs: 1
     * - choiceMinOccurs: 1
     * @var \StructType\IdentityCard
     */
    public $IdentityCard;
    /**
     * The BankCard
     * Meta information extracted from the WSDL
     * - choice: DrivingLicense | IdentityCard | BankCard
     * - choiceMaxOccurs: 1
     * - choiceMinOccurs: 1
     * @var \StructType\BankCard
     */
    public $BankCard;
    /**
     * Constructor method for IdentityData
     * @uses IdentityData::setDrivingLicense()
     * @uses IdentityData::setIdentityCard()
     * @uses IdentityData::setBankCard()
     * @param \StructType\DrivingLicense $drivingLicense
     * @param \StructType\IdentityCard $identityCard
     * @param \StructType\BankCard $bankCard
     */
    public function __construct(\StructType\DrivingLicense $drivingLicense = null, \StructType\IdentityCard $identityCard = null, \StructType\BankCard $bankCard = null)
    {
        $this
            ->setDrivingLicense($drivingLicense)
            ->setIdentityCard($identityCard)
            ->setBankCard($bankCard);
    }
    /**
     * Get DrivingLicense value
     * @return \StructType\DrivingLicense|null
     */
    public function getDrivingLicense()
    {
        return isset($this->DrivingLicense) ? $this->DrivingLicense : null;
    }
    /**
     * This method is responsible for validating the value passed to the setDrivingLicense method
     * This method is willingly generated in order to preserve the one-line inline validation within the setDrivingLicense method
     * This has to validate that the property which is being set is the only one among the given choices
     * @param mixed $value
     * @return string A non-empty message if the values does not match the validation rules
     */
    public function validateDrivingLicenseForChoiceConstraintsFromSetDrivingLicense($value)
    {
        $message = '';
        if (is_null($value)) {
            return $message;
        }
        $properties = [
            'IdentityCard',
            'BankCard',
        ];
        try {
            foreach ($properties as $property) {
                if (isset($this->{$property})) {
                    throw new \InvalidArgumentException(sprintf('The property DrivingLicense can\'t be set as the property %s is already set. Only one property must be set among these properties: DrivingLicense, %s.', $property, implode(', ', $properties)), __LINE__);
                }
            }
        } catch (\InvalidArgumentException $e) {
            $message = $e->getMessage();
        }
        return $message;
    }
    /**
     * Set DrivingLicense value
     * This property belongs to a choice that allows only one property to exist. It is
     * therefore removable from the request, consequently if the value assigned to this
     * property is null, the property is removed from this object
     * @throws \InvalidArgumentException
     * @param \StructType\DrivingLicense $drivingLicense
     * @return \StructType\IdentityData
     */
    public function setDrivingLicense(\StructType\DrivingLicense $drivingLicense = null)
    {
        // validation for constraint: choice(DrivingLicense, IdentityCard, BankCard)
        if ('' !== ($drivingLicenseChoiceErrorMessage = self::validateDrivingLicenseForChoiceConstraintsFromSetDrivingLicense($drivingLicense))) {
            throw new \InvalidArgumentException($drivingLicenseChoiceErrorMessage, __LINE__);
        }
        if (is_null($drivingLicense) || (is_array($drivingLicense) && empty($drivingLicense))) {
            unset($this->DrivingLicense);
        } else {
            $this->DrivingLicense = $drivingLicense;
        }
        return $this;
    }
    /**
     * Get IdentityCard value
     * @return \StructType\IdentityCard|null
     */
    public function getIdentityCard()
    {
        return isset($this->IdentityCard) ? $this->IdentityCard : null;
    }
    /**
     * This method is responsible for validating the value passed to the setIdentityCard method
     * This method is willingly generated in order to preserve the one-line inline validation within the setIdentityCard method
     * This has to validate that the property which is being set is the only one among the given choices
     * @param mixed $value
     * @return string A non-empty message if the values does not match the validation rules
     */
    public function validateIdentityCardForChoiceConstraintsFromSetIdentityCard($value)
    {
        $message = '';
        if (is_null($value)) {
            return $message;
        }
        $properties = [
            'DrivingLicense',
            'BankCard',
        ];
        try {
            foreach ($properties as $property) {
                if (isset($this->{$property})) {
                    throw new \InvalidArgumentException(sprintf('The property IdentityCard can\'t be set as the property %s is already set. Only one property must be set among these properties: IdentityCard, %s.', $property, implode(', ', $properties)), __LINE__);
                }
            }
        } catch (\InvalidArgumentException $e) {
            $message = $e->getMessage();
        }
        return $message;
    }
    /**
     * Set IdentityCard value
     * This property belongs to a choice that allows only one property to exist. It is
     * therefore removable from the request, consequently if the value assigned to this
     * property is null, the property is removed from this object
     * @throws \InvalidArgumentException
     * @param \StructType\IdentityCard $identityCard
     * @return \StructType\IdentityData
     */
    public function setIdentityCard(\StructType\IdentityCard $identityCard = null)
    {
        // validation for constraint: choice(DrivingLicense, IdentityCard, BankCard)
        if ('' !== ($identityCardChoiceErrorMessage = self::validateIdentityCardForChoiceConstraintsFromSetIdentityCard($identityCard))) {
            throw new \InvalidArgumentException($identityCardChoiceErrorMessage, __LINE__);
        }
        if (is_null($identityCard) || (is_array($identityCard) && empty($identityCard))) {
            unset($this->IdentityCard);
        } else {
            $this->IdentityCard = $identityCard;
        }
        return $this;
    }
    /**
     * Get BankCard value
     * @return \StructType\BankCard|null
     */
    public function getBankCard()
    {
        return isset($this->BankCard) ? $this->BankCard : null;
    }
    /**
     * This method is responsible for validating the value passed to the setBankCard method
     * This method is willingly generated in order to preserve the one-line inline validation within the setBankCard method
     * This has to validate that the property which is being set is the only one among the given choices
     * @param mixed $value
     * @return string A non-empty message if the values does not match the validation rules
     */
    public function validateBankCardForChoiceConstraintsFromSetBankCard($value)
    {
        $message = '';
        if (is_null($value)) {
            return $message;
        }
        $properties = [
            'DrivingLicense',
            'IdentityCard',
        ];
        try {
            foreach ($properties as $property) {
                if (isset($this->{$property})) {
                    throw new \InvalidArgumentException(sprintf('The property BankCard can\'t be set as the property %s is already set. Only one property must be set among these properties: BankCard, %s.', $property, implode(', ', $properties)), __LINE__);
                }
            }
        } catch (\InvalidArgumentException $e) {
            $message = $e->getMessage();
        }
        return $message;
    }
    /**
     * Set BankCard value
     * This property belongs to a choice that allows only one property to exist. It is
     * therefore removable from the request, consequently if the value assigned to this
     * property is null, the property is removed from this object
     * @throws \InvalidArgumentException
     * @param \StructType\BankCard $bankCard
     * @return \StructType\IdentityData
     */
    public function setBankCard(\StructType\BankCard $bankCard = null)
    {
        // validation for constraint: choice(DrivingLicense, IdentityCard, BankCard)
        if ('' !== ($bankCardChoiceErrorMessage = self::validateBankCardForChoiceConstraintsFromSetBankCard($bankCard))) {
            throw new \InvalidArgumentException($bankCardChoiceErrorMessage, __LINE__);
        }
        if (is_null($bankCard) || (is_array($bankCard) && empty($bankCard))) {
            unset($this->BankCard);
        } else {
            $this->BankCard = $bankCard;
        }
        return $this;
    }
}
