<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for ExportDocumentType StructType
 * Meta information extracted from the WSDL
 * - documentation: The data of the export document for a shipment.
 * @subpackage Structs
 */
class ExportDocumentType extends AbstractStructBase
{
    /**
     * The exportType
     * Meta information extracted from the WSDL
     * - minOccurs: 1
     * @var string
     */
    public $exportType;
    /**
     * The invoiceNumber
     * Meta information extracted from the WSDL
     * - documentation: Invoice number if applicable
     * - base: xs:string
     * - maxLength: 35
     * - minOccurs: 0
     * @var string
     */
    public $invoiceNumber;
    /**
     * The exportTypeDescription
     * Meta information extracted from the WSDL
     * - documentation: Description mandatory if ExportType is OTHER.
     * - base: xs:string
     * - maxLength: 50
     * - minLength: 1
     * - minOccurs: 0
     * @var string
     */
    public $exportTypeDescription;
    /**
     * The termsOfTrade
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $termsOfTrade;
    /**
     * The placeOfCommital
     * Meta information extracted from the WSDL
     * - documentation: PlaceOfCommital is a Locaton the shipment is handed over to DHL
     * - base: xs:string
     * - maxLength: 35
     * @var string
     */
    public $placeOfCommital;
    /**
     * The additionalFee
     * Meta information extracted from the WSDL
     * - documentation: Postage costs billed in the invoice
     * - base: xs:decimal
     * - fractionDigits: 2
     * - maxInclusive: 9999999.99
     * - minInclusive: 0.0
     * - minOccurs: 0
     * @var float
     */
    public $additionalFee;
    /**
     * The customsCurrency
     * Meta information extracted from the WSDL
     * - documentation: CustomsCurrency refers to all stated goods / customs values as well as postage costs. The information has to match the currency of the commercial invoice or the invoice for customs purposes. ISO 4217 alpha, p.E.: EUR for Euro USD for
     * US Dollar GBP for British Pound
     * - base: xs:string
     * - maxLength: 3
     * - minOccurs: 0
     * @var string
     */
    public $customsCurrency;
    /**
     * The permitNumber
     * Meta information extracted from the WSDL
     * - documentation: The permit number.
     * - base: xs:string
     * - maxLength: 35
     * - minOccurs: 0
     * @var string
     */
    public $permitNumber;
    /**
     * The attestationNumber
     * Meta information extracted from the WSDL
     * - documentation: The attestation number.
     * - base: xs:string
     * - maxLength: 35
     * - minOccurs: 0
     * @var string
     */
    public $attestationNumber;
    /**
     * The addresseesCustomsReference
     * Meta information extracted from the WSDL
     * - documentation: The customs reference is used by customs authorities to identify economics operators an/or other persons involved. With the given reference, granted authorizations and/or relevant processes in customs clearance an/or taxation can be
     * taken into account.
     * - base: xs:string
     * - maxLength: 35
     * - minOccurs: 0
     * @var string
     */
    public $addresseesCustomsReference;
    /**
     * The sendersCustomsReference
     * Meta information extracted from the WSDL
     * - documentation: The customs reference is used by customs authorities to identify economics operators an/or other persons involved. With the given reference, granted authorizations and/or relevant processes in customs clearance an/or taxation can be
     * taken into account.
     * - base: xs:string
     * - maxLength: 35
     * - minOccurs: 0
     * @var string
     */
    public $sendersCustomsReference;
    /**
     * The WithElectronicExportNtfctn
     * Meta information extracted from the WSDL
     * - documentation: Sets an electronic export notification.
     * - minOccurs: 0
     * @var \StructType\Serviceconfiguration
     */
    public $WithElectronicExportNtfctn;
    /**
     * The ExportDocPosition
     * Meta information extracted from the WSDL
     * - maxOccurs: 99
     * - minOccurs: 0
     * @var \StructType\ExportDocPosition[]
     */
    public $ExportDocPosition;
    /**
     * Constructor method for ExportDocumentType
     * @uses ExportDocumentType::setExportType()
     * @uses ExportDocumentType::setInvoiceNumber()
     * @uses ExportDocumentType::setExportTypeDescription()
     * @uses ExportDocumentType::setTermsOfTrade()
     * @uses ExportDocumentType::setPlaceOfCommital()
     * @uses ExportDocumentType::setAdditionalFee()
     * @uses ExportDocumentType::setCustomsCurrency()
     * @uses ExportDocumentType::setPermitNumber()
     * @uses ExportDocumentType::setAttestationNumber()
     * @uses ExportDocumentType::setAddresseesCustomsReference()
     * @uses ExportDocumentType::setSendersCustomsReference()
     * @uses ExportDocumentType::setWithElectronicExportNtfctn()
     * @uses ExportDocumentType::setExportDocPosition()
     * @param string $exportType
     * @param string $invoiceNumber
     * @param string $exportTypeDescription
     * @param string $termsOfTrade
     * @param string $placeOfCommital
     * @param float $additionalFee
     * @param string $customsCurrency
     * @param string $permitNumber
     * @param string $attestationNumber
     * @param string $addresseesCustomsReference
     * @param string $sendersCustomsReference
     * @param \StructType\Serviceconfiguration $withElectronicExportNtfctn
     * @param \StructType\ExportDocPosition[] $exportDocPosition
     */
    public function __construct($exportType = null, $invoiceNumber = null, $exportTypeDescription = null, $termsOfTrade = null, $placeOfCommital = null, $additionalFee = null, $customsCurrency = null, $permitNumber = null, $attestationNumber = null, $addresseesCustomsReference = null, $sendersCustomsReference = null, \StructType\Serviceconfiguration $withElectronicExportNtfctn = null, array $exportDocPosition = array())
    {
        $this
            ->setExportType($exportType)
            ->setInvoiceNumber($invoiceNumber)
            ->setExportTypeDescription($exportTypeDescription)
            ->setTermsOfTrade($termsOfTrade)
            ->setPlaceOfCommital($placeOfCommital)
            ->setAdditionalFee($additionalFee)
            ->setCustomsCurrency($customsCurrency)
            ->setPermitNumber($permitNumber)
            ->setAttestationNumber($attestationNumber)
            ->setAddresseesCustomsReference($addresseesCustomsReference)
            ->setSendersCustomsReference($sendersCustomsReference)
            ->setWithElectronicExportNtfctn($withElectronicExportNtfctn)
            ->setExportDocPosition($exportDocPosition);
    }
    /**
     * Get exportType value
     * @return string
     */
    public function getExportType()
    {
        return $this->exportType;
    }
    /**
     * Set exportType value
     * @uses \EnumType\ExportType::valueIsValid()
     * @uses \EnumType\ExportType::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $exportType
     * @return \StructType\ExportDocumentType
     */
    public function setExportType($exportType = null)
    {
        // validation for constraint: enumeration
        if (!\EnumType\ExportType::valueIsValid($exportType)) {
            throw new \InvalidArgumentException(sprintf('Invalid value(s) %s, please use one of: %s from enumeration class \EnumType\ExportType', is_array($exportType) ? implode(', ', $exportType) : var_export($exportType, true), implode(', ', \EnumType\ExportType::getValidValues())), __LINE__);
        }
        $this->exportType = $exportType;
        return $this;
    }
    /**
     * Get invoiceNumber value
     * @return string|null
     */
    public function getInvoiceNumber()
    {
        return $this->invoiceNumber;
    }
    /**
     * Set invoiceNumber value
     * @param string $invoiceNumber
     * @return \StructType\ExportDocumentType
     */
    public function setInvoiceNumber($invoiceNumber = null)
    {
        // validation for constraint: string
        if (!is_null($invoiceNumber) && !is_string($invoiceNumber)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($invoiceNumber, true), gettype($invoiceNumber)), __LINE__);
        }
        // validation for constraint: maxLength(35)
        if (!is_null($invoiceNumber) && mb_strlen($invoiceNumber) > 35) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be less than or equal to 35', mb_strlen($invoiceNumber)), __LINE__);
        }
        $this->invoiceNumber = $invoiceNumber;
        return $this;
    }
    /**
     * Get exportTypeDescription value
     * @return string|null
     */
    public function getExportTypeDescription()
    {
        return $this->exportTypeDescription;
    }
    /**
     * Set exportTypeDescription value
     * @param string $exportTypeDescription
     * @return \StructType\ExportDocumentType
     */
    public function setExportTypeDescription($exportTypeDescription = null)
    {
        // validation for constraint: string
        if (!is_null($exportTypeDescription) && !is_string($exportTypeDescription)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($exportTypeDescription, true), gettype($exportTypeDescription)), __LINE__);
        }
        // validation for constraint: maxLength(50)
        if (!is_null($exportTypeDescription) && mb_strlen($exportTypeDescription) > 50) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be less than or equal to 50', mb_strlen($exportTypeDescription)), __LINE__);
        }
        // validation for constraint: minLength(1)
        if (!is_null($exportTypeDescription) && mb_strlen($exportTypeDescription) < 1) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be greater than or equal to 1', mb_strlen($exportTypeDescription)), __LINE__);
        }
        $this->exportTypeDescription = $exportTypeDescription;
        return $this;
    }
    /**
     * Get termsOfTrade value
     * @return string|null
     */
    public function getTermsOfTrade()
    {
        return $this->termsOfTrade;
    }
    /**
     * Set termsOfTrade value
     * @uses \EnumType\TermsOfTrade::valueIsValid()
     * @uses \EnumType\TermsOfTrade::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $termsOfTrade
     * @return \StructType\ExportDocumentType
     */
    public function setTermsOfTrade($termsOfTrade = null)
    {
        // validation for constraint: enumeration
        if (!\EnumType\TermsOfTrade::valueIsValid($termsOfTrade)) {
            throw new \InvalidArgumentException(sprintf('Invalid value(s) %s, please use one of: %s from enumeration class \EnumType\TermsOfTrade', is_array($termsOfTrade) ? implode(', ', $termsOfTrade) : var_export($termsOfTrade, true), implode(', ', \EnumType\TermsOfTrade::getValidValues())), __LINE__);
        }
        $this->termsOfTrade = $termsOfTrade;
        return $this;
    }
    /**
     * Get placeOfCommital value
     * @return string|null
     */
    public function getPlaceOfCommital()
    {
        return $this->placeOfCommital;
    }
    /**
     * Set placeOfCommital value
     * @param string $placeOfCommital
     * @return \StructType\ExportDocumentType
     */
    public function setPlaceOfCommital($placeOfCommital = null)
    {
        // validation for constraint: string
        if (!is_null($placeOfCommital) && !is_string($placeOfCommital)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($placeOfCommital, true), gettype($placeOfCommital)), __LINE__);
        }
        // validation for constraint: maxLength(35)
        if (!is_null($placeOfCommital) && mb_strlen($placeOfCommital) > 35) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be less than or equal to 35', mb_strlen($placeOfCommital)), __LINE__);
        }
        $this->placeOfCommital = $placeOfCommital;
        return $this;
    }
    /**
     * Get additionalFee value
     * @return float|null
     */
    public function getAdditionalFee()
    {
        return $this->additionalFee;
    }
    /**
     * Set additionalFee value
     * @param float $additionalFee
     * @return \StructType\ExportDocumentType
     */
    public function setAdditionalFee($additionalFee = null)
    {
        // validation for constraint: float
        if (!is_null($additionalFee) && !(is_float($additionalFee) || is_numeric($additionalFee))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a float value, %s given', var_export($additionalFee, true), gettype($additionalFee)), __LINE__);
        }
        // validation for constraint: fractionDigits(2)
        if (!is_null($additionalFee) && mb_strlen(mb_substr($additionalFee, false !== mb_strpos($additionalFee, '.') ? mb_strpos($additionalFee, '.') + 1 : mb_strlen($additionalFee))) > 2) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, the value must at most contain 2 fraction digits, %d given', var_export($additionalFee, true), mb_strlen(mb_substr($additionalFee, mb_strpos($additionalFee, '.') + 1))), __LINE__);
        }
        // validation for constraint: maxInclusive(9999999.99)
        if (!is_null($additionalFee) && $additionalFee > 9999999.99) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, the value must be numerically less than or equal to 9999999.99', var_export($additionalFee, true)), __LINE__);
        }
        // validation for constraint: minInclusive(0.0)
        if (!is_null($additionalFee) && $additionalFee < 0.0) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, the value must be numerically greater than or equal to 0.0', var_export($additionalFee, true)), __LINE__);
        }
        $this->additionalFee = $additionalFee;
        return $this;
    }
    /**
     * Get customsCurrency value
     * @return string|null
     */
    public function getCustomsCurrency()
    {
        return $this->customsCurrency;
    }
    /**
     * Set customsCurrency value
     * @param string $customsCurrency
     * @return \StructType\ExportDocumentType
     */
    public function setCustomsCurrency($customsCurrency = null)
    {
        // validation for constraint: string
        if (!is_null($customsCurrency) && !is_string($customsCurrency)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($customsCurrency, true), gettype($customsCurrency)), __LINE__);
        }
        // validation for constraint: maxLength(3)
        if (!is_null($customsCurrency) && mb_strlen($customsCurrency) > 3) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be less than or equal to 3', mb_strlen($customsCurrency)), __LINE__);
        }
        $this->customsCurrency = $customsCurrency;
        return $this;
    }
    /**
     * Get permitNumber value
     * @return string|null
     */
    public function getPermitNumber()
    {
        return $this->permitNumber;
    }
    /**
     * Set permitNumber value
     * @param string $permitNumber
     * @return \StructType\ExportDocumentType
     */
    public function setPermitNumber($permitNumber = null)
    {
        // validation for constraint: string
        if (!is_null($permitNumber) && !is_string($permitNumber)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($permitNumber, true), gettype($permitNumber)), __LINE__);
        }
        // validation for constraint: maxLength(35)
        if (!is_null($permitNumber) && mb_strlen($permitNumber) > 35) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be less than or equal to 35', mb_strlen($permitNumber)), __LINE__);
        }
        $this->permitNumber = $permitNumber;
        return $this;
    }
    /**
     * Get attestationNumber value
     * @return string|null
     */
    public function getAttestationNumber()
    {
        return $this->attestationNumber;
    }
    /**
     * Set attestationNumber value
     * @param string $attestationNumber
     * @return \StructType\ExportDocumentType
     */
    public function setAttestationNumber($attestationNumber = null)
    {
        // validation for constraint: string
        if (!is_null($attestationNumber) && !is_string($attestationNumber)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($attestationNumber, true), gettype($attestationNumber)), __LINE__);
        }
        // validation for constraint: maxLength(35)
        if (!is_null($attestationNumber) && mb_strlen($attestationNumber) > 35) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be less than or equal to 35', mb_strlen($attestationNumber)), __LINE__);
        }
        $this->attestationNumber = $attestationNumber;
        return $this;
    }
    /**
     * Get addresseesCustomsReference value
     * @return string|null
     */
    public function getAddresseesCustomsReference()
    {
        return $this->addresseesCustomsReference;
    }
    /**
     * Set addresseesCustomsReference value
     * @param string $addresseesCustomsReference
     * @return \StructType\ExportDocumentType
     */
    public function setAddresseesCustomsReference($addresseesCustomsReference = null)
    {
        // validation for constraint: string
        if (!is_null($addresseesCustomsReference) && !is_string($addresseesCustomsReference)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($addresseesCustomsReference, true), gettype($addresseesCustomsReference)), __LINE__);
        }
        // validation for constraint: maxLength(35)
        if (!is_null($addresseesCustomsReference) && mb_strlen($addresseesCustomsReference) > 35) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be less than or equal to 35', mb_strlen($addresseesCustomsReference)), __LINE__);
        }
        $this->addresseesCustomsReference = $addresseesCustomsReference;
        return $this;
    }
    /**
     * Get sendersCustomsReference value
     * @return string|null
     */
    public function getSendersCustomsReference()
    {
        return $this->sendersCustomsReference;
    }
    /**
     * Set sendersCustomsReference value
     * @param string $sendersCustomsReference
     * @return \StructType\ExportDocumentType
     */
    public function setSendersCustomsReference($sendersCustomsReference = null)
    {
        // validation for constraint: string
        if (!is_null($sendersCustomsReference) && !is_string($sendersCustomsReference)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($sendersCustomsReference, true), gettype($sendersCustomsReference)), __LINE__);
        }
        // validation for constraint: maxLength(35)
        if (!is_null($sendersCustomsReference) && mb_strlen($sendersCustomsReference) > 35) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be less than or equal to 35', mb_strlen($sendersCustomsReference)), __LINE__);
        }
        $this->sendersCustomsReference = $sendersCustomsReference;
        return $this;
    }
    /**
     * Get WithElectronicExportNtfctn value
     * @return \StructType\Serviceconfiguration|null
     */
    public function getWithElectronicExportNtfctn()
    {
        return $this->WithElectronicExportNtfctn;
    }
    /**
     * Set WithElectronicExportNtfctn value
     * @param \StructType\Serviceconfiguration $withElectronicExportNtfctn
     * @return \StructType\ExportDocumentType
     */
    public function setWithElectronicExportNtfctn(\StructType\Serviceconfiguration $withElectronicExportNtfctn = null)
    {
        $this->WithElectronicExportNtfctn = $withElectronicExportNtfctn;
        return $this;
    }
    /**
     * Get ExportDocPosition value
     * @return \StructType\ExportDocPosition[]|null
     */
    public function getExportDocPosition()
    {
        return $this->ExportDocPosition;
    }
    /**
     * This method is responsible for validating the values passed to the setExportDocPosition method
     * This method is willingly generated in order to preserve the one-line inline validation within the setExportDocPosition method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateExportDocPositionForArrayConstraintsFromSetExportDocPosition(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $exportDocumentTypeExportDocPositionItem) {
            // validation for constraint: itemType
            if (!$exportDocumentTypeExportDocPositionItem instanceof \StructType\ExportDocPosition) {
                $invalidValues[] = is_object($exportDocumentTypeExportDocPositionItem) ? get_class($exportDocumentTypeExportDocPositionItem) : sprintf('%s(%s)', gettype($exportDocumentTypeExportDocPositionItem), var_export($exportDocumentTypeExportDocPositionItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The ExportDocPosition property can only contain items of type \StructType\ExportDocPosition, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set ExportDocPosition value
     * @throws \InvalidArgumentException
     * @param \StructType\ExportDocPosition[] $exportDocPosition
     * @return \StructType\ExportDocumentType
     */
    public function setExportDocPosition(array $exportDocPosition = array())
    {
        // validation for constraint: array
        if ('' !== ($exportDocPositionArrayErrorMessage = self::validateExportDocPositionForArrayConstraintsFromSetExportDocPosition($exportDocPosition))) {
            throw new \InvalidArgumentException($exportDocPositionArrayErrorMessage, __LINE__);
        }
        // validation for constraint: maxOccurs(99)
        if (is_array($exportDocPosition) && count($exportDocPosition) > 99) {
            throw new \InvalidArgumentException(sprintf('Invalid count of %s, the number of elements contained by the property must be less than or equal to 99', count($exportDocPosition)), __LINE__);
        }
        $this->ExportDocPosition = $exportDocPosition;
        return $this;
    }
    /**
     * Add item to ExportDocPosition value
     * @throws \InvalidArgumentException
     * @param \StructType\ExportDocPosition $item
     * @return \StructType\ExportDocumentType
     */
    public function addToExportDocPosition(\StructType\ExportDocPosition $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \StructType\ExportDocPosition) {
            throw new \InvalidArgumentException(sprintf('The ExportDocPosition property can only contain items of type \StructType\ExportDocPosition, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        // validation for constraint: maxOccurs(99)
        if (is_array($this->ExportDocPosition) && count($this->ExportDocPosition) >= 99) {
            throw new \InvalidArgumentException(sprintf('You can\'t add anymore element to this property that already contains %s elements, the number of elements contained by the property must be less than or equal to 99', count($this->ExportDocPosition)), __LINE__);
        }
        $this->ExportDocPosition[] = $item;
        return $this;
    }
}
