<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for ExportDocData StructType
 * Meta information extracted from the WSDL
 * - documentation: ShipmentNumber | The status of the getLabel operation and the url for requesting the label (if available)
 * @subpackage Structs
 */
class ExportDocData extends AbstractStructBase
{
    /**
     * The shipmentNumber
     * Meta information extracted from the WSDL
     * - documentation: Can contain any DHL shipmentnumber. | Can contain any DHL shipmentnumber. For successful and unsuccessful operations, the requested ShipmentNumber to be deleted is returned. This is no matter if the operation could be performed or
     * not.
     * - base: xs:string
     * - maxLength: 39
     * - ref: cis:shipmentNumber
     * @var string
     */
    public $shipmentNumber;
    /**
     * The Status
     * Meta information extracted from the WSDL
     * - documentation: Status of the request (value of zero means, the request was processed without error; value greater than zero indicates that an error occurred).
     * @var \StructType\Statusinformation
     */
    public $Status;
    /**
     * The exportDocData
     * Meta information extracted from the WSDL
     * - documentation: Export doc as base64 encoded pdf data
     * - choice: exportDocData | exportDocURL
     * - choiceMaxOccurs: 1
     * - choiceMinOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $exportDocData;
    /**
     * The exportDocURL
     * Meta information extracted from the WSDL
     * - documentation: URL for downloading the Export doc as pdf
     * - choice: exportDocData | exportDocURL
     * - choiceMaxOccurs: 1
     * - choiceMinOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $exportDocURL;
    /**
     * Constructor method for ExportDocData
     * @uses ExportDocData::setShipmentNumber()
     * @uses ExportDocData::setStatus()
     * @uses ExportDocData::setExportDocData()
     * @uses ExportDocData::setExportDocURL()
     * @param string $shipmentNumber
     * @param \StructType\Statusinformation $status
     * @param string $exportDocData
     * @param string $exportDocURL
     */
    public function __construct($shipmentNumber = null, \StructType\Statusinformation $status = null, $exportDocData = null, $exportDocURL = null)
    {
        $this
            ->setShipmentNumber($shipmentNumber)
            ->setStatus($status)
            ->setExportDocData($exportDocData)
            ->setExportDocURL($exportDocURL);
    }
    /**
     * Get shipmentNumber value
     * @return string|null
     */
    public function getShipmentNumber()
    {
        return $this->shipmentNumber;
    }
    /**
     * Set shipmentNumber value
     * @param string $shipmentNumber
     * @return \StructType\ExportDocData
     */
    public function setShipmentNumber($shipmentNumber = null)
    {
        // validation for constraint: string
        if (!is_null($shipmentNumber) && !is_string($shipmentNumber)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($shipmentNumber, true), gettype($shipmentNumber)), __LINE__);
        }
        // validation for constraint: maxLength(39)
        if (!is_null($shipmentNumber) && mb_strlen($shipmentNumber) > 39) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be less than or equal to 39', mb_strlen($shipmentNumber)), __LINE__);
        }
        $this->shipmentNumber = $shipmentNumber;
        return $this;
    }
    /**
     * Get Status value
     * @return \StructType\Statusinformation|null
     */
    public function getStatus()
    {
        return $this->Status;
    }
    /**
     * Set Status value
     * @param \StructType\Statusinformation $status
     * @return \StructType\ExportDocData
     */
    public function setStatus(\StructType\Statusinformation $status = null)
    {
        $this->Status = $status;
        return $this;
    }
    /**
     * Get exportDocData value
     * @return string|null
     */
    public function getExportDocData()
    {
        return isset($this->exportDocData) ? $this->exportDocData : null;
    }
    /**
     * This method is responsible for validating the value passed to the setExportDocData method
     * This method is willingly generated in order to preserve the one-line inline validation within the setExportDocData method
     * This has to validate that the property which is being set is the only one among the given choices
     * @param mixed $value
     * @return string A non-empty message if the values does not match the validation rules
     */
    public function validateExportDocDataForChoiceConstraintsFromSetExportDocData($value)
    {
        $message = '';
        if (is_null($value)) {
            return $message;
        }
        $properties = [
            'exportDocURL',
        ];
        try {
            foreach ($properties as $property) {
                if (isset($this->{$property})) {
                    throw new \InvalidArgumentException(sprintf('The property exportDocData can\'t be set as the property %s is already set. Only one property must be set among these properties: exportDocData, %s.', $property, implode(', ', $properties)), __LINE__);
                }
            }
        } catch (\InvalidArgumentException $e) {
            $message = $e->getMessage();
        }
        return $message;
    }
    /**
     * Set exportDocData value
     * This property belongs to a choice that allows only one property to exist. It is
     * therefore removable from the request, consequently if the value assigned to this
     * property is null, the property is removed from this object
     * @throws \InvalidArgumentException
     * @param string $exportDocData
     * @return \StructType\ExportDocData
     */
    public function setExportDocData($exportDocData = null)
    {
        // validation for constraint: string
        if (!is_null($exportDocData) && !is_string($exportDocData)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($exportDocData, true), gettype($exportDocData)), __LINE__);
        }
        // validation for constraint: choice(exportDocData, exportDocURL)
        if ('' !== ($exportDocDataChoiceErrorMessage = self::validateExportDocDataForChoiceConstraintsFromSetExportDocData($exportDocData))) {
            throw new \InvalidArgumentException($exportDocDataChoiceErrorMessage, __LINE__);
        }
        if (is_null($exportDocData) || (is_array($exportDocData) && empty($exportDocData))) {
            unset($this->exportDocData);
        } else {
            $this->exportDocData = $exportDocData;
        }
        return $this;
    }
    /**
     * Get exportDocURL value
     * @return string|null
     */
    public function getExportDocURL()
    {
        return isset($this->exportDocURL) ? $this->exportDocURL : null;
    }
    /**
     * This method is responsible for validating the value passed to the setExportDocURL method
     * This method is willingly generated in order to preserve the one-line inline validation within the setExportDocURL method
     * This has to validate that the property which is being set is the only one among the given choices
     * @param mixed $value
     * @return string A non-empty message if the values does not match the validation rules
     */
    public function validateExportDocURLForChoiceConstraintsFromSetExportDocURL($value)
    {
        $message = '';
        if (is_null($value)) {
            return $message;
        }
        $properties = [
            'exportDocData',
        ];
        try {
            foreach ($properties as $property) {
                if (isset($this->{$property})) {
                    throw new \InvalidArgumentException(sprintf('The property exportDocURL can\'t be set as the property %s is already set. Only one property must be set among these properties: exportDocURL, %s.', $property, implode(', ', $properties)), __LINE__);
                }
            }
        } catch (\InvalidArgumentException $e) {
            $message = $e->getMessage();
        }
        return $message;
    }
    /**
     * Set exportDocURL value
     * This property belongs to a choice that allows only one property to exist. It is
     * therefore removable from the request, consequently if the value assigned to this
     * property is null, the property is removed from this object
     * @throws \InvalidArgumentException
     * @param string $exportDocURL
     * @return \StructType\ExportDocData
     */
    public function setExportDocURL($exportDocURL = null)
    {
        // validation for constraint: string
        if (!is_null($exportDocURL) && !is_string($exportDocURL)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($exportDocURL, true), gettype($exportDocURL)), __LINE__);
        }
        // validation for constraint: choice(exportDocData, exportDocURL)
        if ('' !== ($exportDocURLChoiceErrorMessage = self::validateExportDocURLForChoiceConstraintsFromSetExportDocURL($exportDocURL))) {
            throw new \InvalidArgumentException($exportDocURLChoiceErrorMessage, __LINE__);
        }
        if (is_null($exportDocURL) || (is_array($exportDocURL) && empty($exportDocURL))) {
            unset($this->exportDocURL);
        } else {
            $this->exportDocURL = $exportDocURL;
        }
        return $this;
    }
}
