<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for DoManifestResponse StructType
 * Meta information extracted from the WSDL
 * - documentation: The version of the webservice implementation. | The status of the operation
 * @subpackage Structs
 */
class DoManifestResponse extends AbstractStructBase
{
    /**
     * The Version
     * Meta information extracted from the WSDL
     * - ref: bcs:Version
     * @var \StructType\Version
     */
    public $Version;
    /**
     * The Status
     * Meta information extracted from the WSDL
     * - documentation: Status of the request (value of zero means, the request was processed without error; value greater than zero indicates that an error occurred).
     * @var \StructType\Statusinformation
     */
    public $Status;
    /**
     * The ManifestState
     * Meta information extracted from the WSDL
     * - documentation: The status of the operation for the corresponding shipment.
     * - maxOccurs: 30
     * - minOccurs: 0
     * @var \StructType\ManifestState[]
     */
    public $ManifestState;
    /**
     * Constructor method for DoManifestResponse
     * @uses DoManifestResponse::setVersion()
     * @uses DoManifestResponse::setStatus()
     * @uses DoManifestResponse::setManifestState()
     * @param \StructType\Version $version
     * @param \StructType\Statusinformation $status
     * @param \StructType\ManifestState[] $manifestState
     */
    public function __construct(\StructType\Version $version = null, \StructType\Statusinformation $status = null, array $manifestState = array())
    {
        $this
            ->setVersion($version)
            ->setStatus($status)
            ->setManifestState($manifestState);
    }
    /**
     * Get Version value
     * @return \StructType\Version|null
     */
    public function getVersion()
    {
        return $this->Version;
    }
    /**
     * Set Version value
     * @param \StructType\Version $version
     * @return \StructType\DoManifestResponse
     */
    public function setVersion(\StructType\Version $version = null)
    {
        $this->Version = $version;
        return $this;
    }
    /**
     * Get Status value
     * @return \StructType\Statusinformation|null
     */
    public function getStatus()
    {
        return $this->Status;
    }
    /**
     * Set Status value
     * @param \StructType\Statusinformation $status
     * @return \StructType\DoManifestResponse
     */
    public function setStatus(\StructType\Statusinformation $status = null)
    {
        $this->Status = $status;
        return $this;
    }
    /**
     * Get ManifestState value
     * @return \StructType\ManifestState[]|null
     */
    public function getManifestState()
    {
        return $this->ManifestState;
    }
    /**
     * This method is responsible for validating the values passed to the setManifestState method
     * This method is willingly generated in order to preserve the one-line inline validation within the setManifestState method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateManifestStateForArrayConstraintsFromSetManifestState(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $doManifestResponseManifestStateItem) {
            // validation for constraint: itemType
            if (!$doManifestResponseManifestStateItem instanceof \StructType\ManifestState) {
                $invalidValues[] = is_object($doManifestResponseManifestStateItem) ? get_class($doManifestResponseManifestStateItem) : sprintf('%s(%s)', gettype($doManifestResponseManifestStateItem), var_export($doManifestResponseManifestStateItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The ManifestState property can only contain items of type \StructType\ManifestState, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set ManifestState value
     * @throws \InvalidArgumentException
     * @param \StructType\ManifestState[] $manifestState
     * @return \StructType\DoManifestResponse
     */
    public function setManifestState(array $manifestState = array())
    {
        // validation for constraint: array
        if ('' !== ($manifestStateArrayErrorMessage = self::validateManifestStateForArrayConstraintsFromSetManifestState($manifestState))) {
            throw new \InvalidArgumentException($manifestStateArrayErrorMessage, __LINE__);
        }
        // validation for constraint: maxOccurs(30)
        if (is_array($manifestState) && count($manifestState) > 30) {
            throw new \InvalidArgumentException(sprintf('Invalid count of %s, the number of elements contained by the property must be less than or equal to 30', count($manifestState)), __LINE__);
        }
        $this->ManifestState = $manifestState;
        return $this;
    }
    /**
     * Add item to ManifestState value
     * @throws \InvalidArgumentException
     * @param \StructType\ManifestState $item
     * @return \StructType\DoManifestResponse
     */
    public function addToManifestState(\StructType\ManifestState $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \StructType\ManifestState) {
            throw new \InvalidArgumentException(sprintf('The ManifestState property can only contain items of type \StructType\ManifestState, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        // validation for constraint: maxOccurs(30)
        if (is_array($this->ManifestState) && count($this->ManifestState) >= 30) {
            throw new \InvalidArgumentException(sprintf('You can\'t add anymore element to this property that already contains %s elements, the number of elements contained by the property must be less than or equal to 30', count($this->ManifestState)), __LINE__);
        }
        $this->ManifestState[] = $item;
        return $this;
    }
}
