<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for DeletionState StructType
 * Meta information extracted from the WSDL
 * - documentation: For successful and unsuccessful operations, the requested ShipmentNumber to be deleted is returned. This is no matter if the operation could be performed or not. | The status of a deleteShipment operation.
 * @subpackage Structs
 */
class DeletionState extends AbstractStructBase
{
    /**
     * The shipmentNumber
     * Meta information extracted from the WSDL
     * - documentation: Can contain any DHL shipmentnumber. | Can contain any DHL shipmentnumber. For successful and unsuccessful operations, the requested ShipmentNumber to be deleted is returned. This is no matter if the operation could be performed or
     * not.
     * - base: xs:string
     * - maxLength: 39
     * - ref: cis:shipmentNumber
     * @var string
     */
    public $shipmentNumber;
    /**
     * The Status
     * Meta information extracted from the WSDL
     * - documentation: Success status of processing the deletion of particular shipment.
     * @var \StructType\Statusinformation
     */
    public $Status;
    /**
     * Constructor method for DeletionState
     * @uses DeletionState::setShipmentNumber()
     * @uses DeletionState::setStatus()
     * @param string $shipmentNumber
     * @param \StructType\Statusinformation $status
     */
    public function __construct($shipmentNumber = null, \StructType\Statusinformation $status = null)
    {
        $this
            ->setShipmentNumber($shipmentNumber)
            ->setStatus($status);
    }
    /**
     * Get shipmentNumber value
     * @return string|null
     */
    public function getShipmentNumber()
    {
        return $this->shipmentNumber;
    }
    /**
     * Set shipmentNumber value
     * @param string $shipmentNumber
     * @return \StructType\DeletionState
     */
    public function setShipmentNumber($shipmentNumber = null)
    {
        // validation for constraint: string
        if (!is_null($shipmentNumber) && !is_string($shipmentNumber)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($shipmentNumber, true), gettype($shipmentNumber)), __LINE__);
        }
        // validation for constraint: maxLength(39)
        if (!is_null($shipmentNumber) && mb_strlen($shipmentNumber) > 39) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be less than or equal to 39', mb_strlen($shipmentNumber)), __LINE__);
        }
        $this->shipmentNumber = $shipmentNumber;
        return $this;
    }
    /**
     * Get Status value
     * @return \StructType\Statusinformation|null
     */
    public function getStatus()
    {
        return $this->Status;
    }
    /**
     * Set Status value
     * @param \StructType\Statusinformation $status
     * @return \StructType\DeletionState
     */
    public function setStatus(\StructType\Statusinformation $status = null)
    {
        $this->Status = $status;
        return $this;
    }
}
