<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for ContactType StructType
 * Meta information extracted from the WSDL
 * - documentation: includes | Type of contact.
 * @subpackage Structs
 */
class ContactType extends AbstractStructBase
{
    /**
     * The Communication
     * Meta information extracted from the WSDL
     * - documentation: Contact communication information.
     * - minOccurs: 0
     * @var \StructType\CommunicationType
     */
    public $Communication;
    /**
     * The Address
     * Meta information extracted from the WSDL
     * - documentation: Contact address.
     * - minOccurs: 0
     * @var \StructType\NativeAddressType
     */
    public $Address;
    /**
     * The Name
     * Meta information extracted from the WSDL
     * - documentation: Contact name.
     * - minOccurs: 0
     * @var \StructType\NameType
     */
    public $Name;
    /**
     * Constructor method for ContactType
     * @uses ContactType::setCommunication()
     * @uses ContactType::setAddress()
     * @uses ContactType::setName()
     * @param \StructType\CommunicationType $communication
     * @param \StructType\NativeAddressType $address
     * @param \StructType\NameType $name
     */
    public function __construct(\StructType\CommunicationType $communication = null, \StructType\NativeAddressType $address = null, \StructType\NameType $name = null)
    {
        $this
            ->setCommunication($communication)
            ->setAddress($address)
            ->setName($name);
    }
    /**
     * Get Communication value
     * @return \StructType\CommunicationType|null
     */
    public function getCommunication()
    {
        return $this->Communication;
    }
    /**
     * Set Communication value
     * @param \StructType\CommunicationType $communication
     * @return \StructType\ContactType
     */
    public function setCommunication(\StructType\CommunicationType $communication = null)
    {
        $this->Communication = $communication;
        return $this;
    }
    /**
     * Get Address value
     * @return \StructType\NativeAddressType|null
     */
    public function getAddress()
    {
        return $this->Address;
    }
    /**
     * Set Address value
     * @param \StructType\NativeAddressType $address
     * @return \StructType\ContactType
     */
    public function setAddress(\StructType\NativeAddressType $address = null)
    {
        $this->Address = $address;
        return $this;
    }
    /**
     * Get Name value
     * @return \StructType\NameType|null
     */
    public function getName()
    {
        return $this->Name;
    }
    /**
     * Set Name value
     * @param \StructType\NameType $name
     * @return \StructType\ContactType
     */
    public function setName(\StructType\NameType $name = null)
    {
        $this->Name = $name;
        return $this;
    }
}
