<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for BookPickupRequest StructType
 * Meta information extracted from the WSDL
 * - documentation: The version of the webservice implementation for which the requesting client is developed. | The data for a pickup order.
 * @subpackage Structs
 */
class BookPickupRequest extends AbstractStructBase
{
    /**
     * The Version
     * Meta information extracted from the WSDL
     * - ref: bcs:Version
     * @var \StructType\Version
     */
    public $Version;
    /**
     * The BookingInformation
     * Meta information extracted from the WSDL
     * - documentation: Contains information in further leaf elements about product, DHL account, pickup date and time, pickup location, amount of pieces, pallets, and shipments, moreover weight and volume weight, size.
     * @var \StructType\PickupBookingInformationType
     */
    public $BookingInformation;
    /**
     * The PickupAddress
     * Meta information extracted from the WSDL
     * - documentation: The pickup address.
     * @var \StructType\PickupAddressType
     */
    public $PickupAddress;
    /**
     * The ContactOrderer
     * Meta information extracted from the WSDL
     * - documentation: The address and contact information of the orderer.
     * - minOccurs: 0
     * @var \StructType\PickupOrdererType
     */
    public $ContactOrderer;
    /**
     * Constructor method for BookPickupRequest
     * @uses BookPickupRequest::setVersion()
     * @uses BookPickupRequest::setBookingInformation()
     * @uses BookPickupRequest::setPickupAddress()
     * @uses BookPickupRequest::setContactOrderer()
     * @param \StructType\Version $version
     * @param \StructType\PickupBookingInformationType $bookingInformation
     * @param \StructType\PickupAddressType $pickupAddress
     * @param \StructType\PickupOrdererType $contactOrderer
     */
    public function __construct(\StructType\Version $version = null, \StructType\PickupBookingInformationType $bookingInformation = null, \StructType\PickupAddressType $pickupAddress = null, \StructType\PickupOrdererType $contactOrderer = null)
    {
        $this
            ->setVersion($version)
            ->setBookingInformation($bookingInformation)
            ->setPickupAddress($pickupAddress)
            ->setContactOrderer($contactOrderer);
    }
    /**
     * Get Version value
     * @return \StructType\Version|null
     */
    public function getVersion()
    {
        return $this->Version;
    }
    /**
     * Set Version value
     * @param \StructType\Version $version
     * @return \StructType\BookPickupRequest
     */
    public function setVersion(\StructType\Version $version = null)
    {
        $this->Version = $version;
        return $this;
    }
    /**
     * Get BookingInformation value
     * @return \StructType\PickupBookingInformationType|null
     */
    public function getBookingInformation()
    {
        return $this->BookingInformation;
    }
    /**
     * Set BookingInformation value
     * @param \StructType\PickupBookingInformationType $bookingInformation
     * @return \StructType\BookPickupRequest
     */
    public function setBookingInformation(\StructType\PickupBookingInformationType $bookingInformation = null)
    {
        $this->BookingInformation = $bookingInformation;
        return $this;
    }
    /**
     * Get PickupAddress value
     * @return \StructType\PickupAddressType|null
     */
    public function getPickupAddress()
    {
        return $this->PickupAddress;
    }
    /**
     * Set PickupAddress value
     * @param \StructType\PickupAddressType $pickupAddress
     * @return \StructType\BookPickupRequest
     */
    public function setPickupAddress(\StructType\PickupAddressType $pickupAddress = null)
    {
        $this->PickupAddress = $pickupAddress;
        return $this;
    }
    /**
     * Get ContactOrderer value
     * @return \StructType\PickupOrdererType|null
     */
    public function getContactOrderer()
    {
        return $this->ContactOrderer;
    }
    /**
     * Set ContactOrderer value
     * @param \StructType\PickupOrdererType $contactOrderer
     * @return \StructType\BookPickupRequest
     */
    public function setContactOrderer(\StructType\PickupOrdererType $contactOrderer = null)
    {
        $this->ContactOrderer = $contactOrderer;
        return $this;
    }
}
