<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for BankCard StructType
 * Meta information extracted from the WSDL
 * - documentation: If a bank card shall be used for verifying identity.
 * @subpackage Structs
 */
class BankCard extends AbstractStructBase
{
    /**
     * The CardType
     * Meta information extracted from the WSDL
     * - documentation: Type of bank card. Mandatory if BankCard is chosen as identity instrument.
     * @var string
     */
    public $CardType;
    /**
     * The CardNumber
     * Meta information extracted from the WSDL
     * - documentation: Number of bank card. Mandatory if BankCard is chosen as identity instrument.
     * @var string
     */
    public $CardNumber;
    /**
     * The BankName
     * Meta information extracted from the WSDL
     * - documentation: Name of bank. Mandatory if BankCard is chosen as identity instrument.
     * @var string
     */
    public $BankName;
    /**
     * The BankCode
     * Meta information extracted from the WSDL
     * - documentation: Bank code. Mandatory if BankCard is chosen as identity instrument.
     * @var string
     */
    public $BankCode;
    /**
     * Constructor method for BankCard
     * @uses BankCard::setCardType()
     * @uses BankCard::setCardNumber()
     * @uses BankCard::setBankName()
     * @uses BankCard::setBankCode()
     * @param string $cardType
     * @param string $cardNumber
     * @param string $bankName
     * @param string $bankCode
     */
    public function __construct($cardType = null, $cardNumber = null, $bankName = null, $bankCode = null)
    {
        $this
            ->setCardType($cardType)
            ->setCardNumber($cardNumber)
            ->setBankName($bankName)
            ->setBankCode($bankCode);
    }
    /**
     * Get CardType value
     * @return string|null
     */
    public function getCardType()
    {
        return $this->CardType;
    }
    /**
     * Set CardType value
     * @param string $cardType
     * @return \StructType\BankCard
     */
    public function setCardType($cardType = null)
    {
        // validation for constraint: string
        if (!is_null($cardType) && !is_string($cardType)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($cardType, true), gettype($cardType)), __LINE__);
        }
        $this->CardType = $cardType;
        return $this;
    }
    /**
     * Get CardNumber value
     * @return string|null
     */
    public function getCardNumber()
    {
        return $this->CardNumber;
    }
    /**
     * Set CardNumber value
     * @param string $cardNumber
     * @return \StructType\BankCard
     */
    public function setCardNumber($cardNumber = null)
    {
        // validation for constraint: string
        if (!is_null($cardNumber) && !is_string($cardNumber)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($cardNumber, true), gettype($cardNumber)), __LINE__);
        }
        $this->CardNumber = $cardNumber;
        return $this;
    }
    /**
     * Get BankName value
     * @return string|null
     */
    public function getBankName()
    {
        return $this->BankName;
    }
    /**
     * Set BankName value
     * @param string $bankName
     * @return \StructType\BankCard
     */
    public function setBankName($bankName = null)
    {
        // validation for constraint: string
        if (!is_null($bankName) && !is_string($bankName)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($bankName, true), gettype($bankName)), __LINE__);
        }
        $this->BankName = $bankName;
        return $this;
    }
    /**
     * Get BankCode value
     * @return string|null
     */
    public function getBankCode()
    {
        return $this->BankCode;
    }
    /**
     * Set BankCode value
     * @param string $bankCode
     * @return \StructType\BankCard
     */
    public function setBankCode($bankCode = null)
    {
        // validation for constraint: string
        if (!is_null($bankCode) && !is_string($bankCode)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($bankCode, true), gettype($bankCode)), __LINE__);
        }
        $this->BankCode = $bankCode;
        return $this;
    }
}
