<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for AuthentificationType StructType
 * Meta information extracted from the WSDL
 * - documentation: includes | Type of authentification
 * @subpackage Structs
 */
class AuthentificationType extends AbstractStructBase
{
    /**
     * The user
     * Meta information extracted from the WSDL
     * - documentation: username for the business customer portal (only lower case)
     * - base: xs:string
     * @var string
     */
    public $user;
    /**
     * The signature
     * Meta information extracted from the WSDL
     * - documentation: password for the business customer portal
     * - base: xs:string
     * - maxLength: 32
     * @var string
     */
    public $signature;
    /**
     * Constructor method for AuthentificationType
     * @uses AuthentificationType::setUser()
     * @uses AuthentificationType::setSignature()
     * @param string $user
     * @param string $signature
     */
    public function __construct($user = null, $signature = null)
    {
        $this
            ->setUser($user)
            ->setSignature($signature);
    }
    /**
     * Get user value
     * @return string|null
     */
    public function getUser()
    {
        return $this->user;
    }
    /**
     * Set user value
     * @param string $user
     * @return \StructType\AuthentificationType
     */
    public function setUser($user = null)
    {
        // validation for constraint: string
        if (!is_null($user) && !is_string($user)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($user, true), gettype($user)), __LINE__);
        }
        $this->user = $user;
        return $this;
    }
    /**
     * Get signature value
     * @return string|null
     */
    public function getSignature()
    {
        return $this->signature;
    }
    /**
     * Set signature value
     * @param string $signature
     * @return \StructType\AuthentificationType
     */
    public function setSignature($signature = null)
    {
        // validation for constraint: string
        if (!is_null($signature) && !is_string($signature)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($signature, true), gettype($signature)), __LINE__);
        }
        // validation for constraint: maxLength(32)
        if (!is_null($signature) && mb_strlen($signature) > 32) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be less than or equal to 32', mb_strlen($signature)), __LINE__);
        }
        $this->signature = $signature;
        return $this;
    }
}
