<?php

namespace ServiceType;

use \WsdlToPhp\PackageBase\AbstractSoapClientBase;

/**
 * This class stands for Do ServiceType
 * @subpackage Services
 */
class _Do extends AbstractSoapClientBase
{
    /**
     * Sets the Authentification SoapHeader param
     * @uses AbstractSoapClientBase::setSoapHeader()
     * @param \StructType\AuthentificationType $authentification
     * @param string $nameSpace
     * @param bool $mustUnderstand
     * @param string $actor
     * @return bool
     */
    public function setSoapHeaderAuthentification(\StructType\AuthentificationType $authentification, $nameSpace = 'http://dhl.de/webservice/cisbase', $mustUnderstand = false, $actor = null)
    {
        return $this->setSoapHeader($nameSpace, 'Authentification', $authentification, $mustUnderstand, $actor);
    }
    /**
     * Method to call the operation originally named doManifest
     * Meta information extracted from the WSDL
     * - SOAPHeaderNames: Authentification
     * - SOAPHeaderNamespaces: http://dhl.de/webservice/cisbase
     * - SOAPHeaderTypes: \StructType\AuthentificationType
     * - SOAPHeaders: required
     * - documentation: Manifest the requested DD shipments. | The identifier for the shipment which should be manifested. | The status of the manifest operation. | Manifest the requested shipments. | The authentication data and the shipment identifier. |
     * The status of the operation.
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\DoManifestRequest $part1
     * @return \StructType\DoManifestResponse|bool
     */
    public function doManifest(\StructType\DoManifestRequest $part1)
    {
        try {
            $this->setResult($this->getSoapClient()->doManifest($part1));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Returns the result
     * @see AbstractSoapClientBase::getResult()
     * @return \StructType\DoManifestResponse
     */
    public function getResult()
    {
        return parent::getResult();
    }
}
