<?php

namespace ServiceType;

use \WsdlToPhp\PackageBase\AbstractSoapClientBase;

/**
 * This class stands for Get ServiceType
 * @subpackage Services
 */
class Get extends AbstractSoapClientBase
{
    /**
     * Sets the Authentification SoapHeader param
     * @uses AbstractSoapClientBase::setSoapHeader()
     * @param \StructType\AuthentificationType $authentification
     * @param string $nameSpace
     * @param bool $mustUnderstand
     * @param string $actor
     * @return bool
     */
    public function setSoapHeaderAuthentification(\StructType\AuthentificationType $authentification, $nameSpace = 'http://dhl.de/webservice/cisbase', $mustUnderstand = false, $actor = null)
    {
        return $this->setSoapHeader($nameSpace, 'Authentification', $authentification, $mustUnderstand, $actor);
    }
    /**
     * Method to call the operation originally named getLabel
     * Meta information extracted from the WSDL
     * - SOAPHeaderNames: Authentification
     * - SOAPHeaderNamespaces: http://dhl.de/webservice/cisbase
     * - SOAPHeaderTypes: \StructType\AuthentificationType
     * - SOAPHeaders: required
     * - documentation: Returns the request-url for getting a label. | The identifier for the shipment for which the label url is requested. | The status of the operation and the label url (if available). | Returns the request-url for getting a label. | The
     * authentication data and the shipment identifier. | The status of the operation and the url for requesting the label.
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\GetLabelRequest $part1
     * @return \StructType\GetLabelResponse|bool
     */
    public function getLabel(\StructType\GetLabelRequest $part1)
    {
        try {
            $this->setResult($this->getSoapClient()->getLabel($part1));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named getVersion
     * Meta information extracted from the WSDL
     * - documentation: Returns the actual version of the implementation of the whole ISService webservice. | The version of webservice implementation. | Returns the actual version of the implementation of the whole ISService webservice. | The version of
     * the implementation.
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\Version $part1
     * @return \StructType\GetVersionResponse|bool
     */
    public function getVersion(\StructType\Version $part1)
    {
        try {
            $this->setResult($this->getSoapClient()->getVersion($part1));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named getExportDoc
     * Meta information extracted from the WSDL
     * - SOAPHeaderNames: Authentification
     * - SOAPHeaderNamespaces: http://dhl.de/webservice/cisbase
     * - SOAPHeaderTypes: \StructType\AuthentificationType
     * - SOAPHeaders: required
     * - documentation: Returns the request-url for getting a export document. | The identifier for the shipment for which the export document url is requested. | The status of the operation and the export document url (if available). | Returns the
     * request-url for getting a export document. | The authentication data and the shipment identifier. | The status of the operation and the url for requesting the export document.
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\GetExportDocRequest $part1
     * @return \StructType\GetExportDocResponse|bool
     */
    public function getExportDoc(\StructType\GetExportDocRequest $part1)
    {
        try {
            $this->setResult($this->getSoapClient()->getExportDoc($part1));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named getManifest
     * Meta information extracted from the WSDL
     * - SOAPHeaderNames: Authentification
     * - SOAPHeaderNamespaces: http://dhl.de/webservice/cisbase
     * - SOAPHeaderTypes: \StructType\AuthentificationType
     * - SOAPHeaders: required
     * - documentation: Request the manifest. | The request data. | The status of the getManifest operation and the manifest url. | Requests the manifest. | The authentication data and the shipment data. | The status of the operation and the manifest url.
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\GetManifestRequest $part1
     * @return \StructType\GetManifestResponse|bool
     */
    public function getManifest(\StructType\GetManifestRequest $part1)
    {
        try {
            $this->setResult($this->getSoapClient()->getManifest($part1));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Returns the result
     * @see AbstractSoapClientBase::getResult()
     * @return \StructType\GetExportDocResponse|\StructType\GetLabelResponse|\StructType\GetManifestResponse|\StructType\GetVersionResponse
     */
    public function getResult()
    {
        return parent::getResult();
    }
}
