<?php

namespace ServiceType;

use \WsdlToPhp\PackageBase\AbstractSoapClientBase;

/**
 * This class stands for Create ServiceType
 * @subpackage Services
 */
class Create extends AbstractSoapClientBase
{
    /**
     * Sets the Authentification SoapHeader param
     * @uses AbstractSoapClientBase::setSoapHeader()
     * @param \StructType\AuthentificationType $authentification
     * @param string $nameSpace
     * @param bool $mustUnderstand
     * @param string $actor
     * @return bool
     */
    public function setSoapHeaderAuthentification(\StructType\AuthentificationType $authentification, $nameSpace = 'http://dhl.de/webservice/cisbase', $mustUnderstand = false, $actor = null)
    {
        return $this->setSoapHeader($nameSpace, 'Authentification', $authentification, $mustUnderstand, $actor);
    }
    /**
     * Method to call the operation originally named createShipmentOrder
     * Meta information extracted from the WSDL
     * - SOAPHeaderNames: Authentification
     * - SOAPHeaderNamespaces: http://dhl.de/webservice/cisbase
     * - SOAPHeaderTypes: \StructType\AuthentificationType
     * - SOAPHeaders: required
     * - documentation: Creates shipments. | The shipment data. | The status of the createShipment operation and the identifier for the shipment. | Creates shipments. | The authentication data and the shipment data. | The status of the operation and the
     * shipment identifier.
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\CreateShipmentOrderRequest $part1
     * @return \StructType\CreateShipmentOrderResponse|bool
     */
    public function createShipmentOrder(\StructType\CreateShipmentOrderRequest $part1)
    {
        try {
            $this->setResult($this->getSoapClient()->createShipmentOrder($part1));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Returns the result
     * @see AbstractSoapClientBase::getResult()
     * @return \StructType\CreateShipmentOrderResponse
     */
    public function getResult()
    {
        return parent::getResult();
    }
}
