<?php

namespace mensajeriabonos\ServiceType;

use \WsdlToPhp\PackageBase\AbstractSoapClientBase;

/**
 * This class stands for Obtener ServiceType
 * @subpackage Services
 */
class Obtener extends AbstractSoapClientBase
{
    /**
     * Method to call the operation originally named
     * obtenerEntidadDesdeCodEquivSistExterno
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \mensajeriabonos\StructType\ObtenerEntidadDesdeCodEquivSistExterno $parameters
     * @return \mensajeriabonos\StructType\ObtenerEntidadDesdeCodEquivSistExternoResponse|bool
     */
    public function obtenerEntidadDesdeCodEquivSistExterno(\mensajeriabonos\StructType\ObtenerEntidadDesdeCodEquivSistExterno $parameters)
    {
        try {
            $this->setResult($this->getSoapClient()->obtenerEntidadDesdeCodEquivSistExterno($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named obtenerIdMensajeAPartirMessageRef
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \mensajeriabonos\StructType\ObtenerIdMensajeAPartirMessageRef $parameters
     * @return \mensajeriabonos\StructType\ObtenerIdMensajeAPartirMessageRefResponse|bool
     */
    public function obtenerIdMensajeAPartirMessageRef(\mensajeriabonos\StructType\ObtenerIdMensajeAPartirMessageRef $parameters)
    {
        try {
            $this->setResult($this->getSoapClient()->obtenerIdMensajeAPartirMessageRef($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Returns the result
     * @see AbstractSoapClientBase::getResult()
     * @return \mensajeriabonos\StructType\ObtenerEntidadDesdeCodEquivSistExternoResponse|\mensajeriabonos\StructType\ObtenerIdMensajeAPartirMessageRefResponse
     */
    public function getResult()
    {
        return parent::getResult();
    }
}
