<?php

namespace mensajeriabonos\ServiceType;

use \WsdlToPhp\PackageBase\AbstractSoapClientBase;

/**
 * This class stands for Enviar ServiceType
 * @subpackage Services
 */
class Enviar extends AbstractSoapClientBase
{
    /**
     * Method to call the operation originally named enviarSms
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \mensajeriabonos\StructType\EnviarSms $parameters
     * @return \mensajeriabonos\StructType\EnviarSmsResponse|bool
     */
    public function enviarSms(\mensajeriabonos\StructType\EnviarSms $parameters)
    {
        try {
            $this->setResult($this->getSoapClient()->enviarSms($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named enviarSmsSimpleCertificado
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \mensajeriabonos\StructType\EnviarSmsSimpleCertificado $parameters
     * @return \mensajeriabonos\StructType\EnviarSmsSimpleCertificadoResponse|bool
     */
    public function enviarSmsSimpleCertificado(\mensajeriabonos\StructType\EnviarSmsSimpleCertificado $parameters)
    {
        try {
            $this->setResult($this->getSoapClient()->enviarSmsSimpleCertificado($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named enviarPushCertificado
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \mensajeriabonos\StructType\EnviarPushCertificado $parameters
     * @return \mensajeriabonos\StructType\EnviarPushCertificadoResponse|bool
     */
    public function enviarPushCertificado(\mensajeriabonos\StructType\EnviarPushCertificado $parameters)
    {
        try {
            $this->setResult($this->getSoapClient()->enviarPushCertificado($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named enviarSmsCertificado
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \mensajeriabonos\StructType\EnviarSmsCertificado $parameters
     * @return \mensajeriabonos\StructType\EnviarSmsCertificadoResponse|bool
     */
    public function enviarSmsCertificado(\mensajeriabonos\StructType\EnviarSmsCertificado $parameters)
    {
        try {
            $this->setResult($this->getSoapClient()->enviarSmsCertificado($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named enviarSMI
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \mensajeriabonos\StructType\EnviarSMI $parameters
     * @return \mensajeriabonos\StructType\EnviarSMIResponse|bool
     */
    public function enviarSMI(\mensajeriabonos\StructType\EnviarSMI $parameters)
    {
        try {
            $this->setResult($this->getSoapClient()->enviarSMI($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named enviarPush
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \mensajeriabonos\StructType\EnviarPush $parameters
     * @return \mensajeriabonos\StructType\EnviarPushResponse|bool
     */
    public function enviarPush(\mensajeriabonos\StructType\EnviarPush $parameters)
    {
        try {
            $this->setResult($this->getSoapClient()->enviarPush($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named enviarSmsSimple
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \mensajeriabonos\StructType\EnviarSmsSimple $parameters
     * @return \mensajeriabonos\StructType\EnviarSmsSimpleResponse|bool
     */
    public function enviarSmsSimple(\mensajeriabonos\StructType\EnviarSmsSimple $parameters)
    {
        try {
            $this->setResult($this->getSoapClient()->enviarSmsSimple($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Returns the result
     * @see AbstractSoapClientBase::getResult()
     * @return \mensajeriabonos\StructType\EnviarPushCertificadoResponse|\mensajeriabonos\StructType\EnviarPushResponse|\mensajeriabonos\StructType\EnviarSMIResponse|\mensajeriabonos\StructType\EnviarSmsCertificadoResponse|\mensajeriabonos\StructType\EnviarSmsResponse|\mensajeriabonos\StructType\EnviarSmsSimpleCertificadoResponse|\mensajeriabonos\StructType\EnviarSmsSimpleResponse
     */
    public function getResult()
    {
        return parent::getResult();
    }
}
