<?php

namespace mensajeriabonos\ServiceType;

use \WsdlToPhp\PackageBase\AbstractSoapClientBase;

/**
 * This class stands for Enviosms ServiceType
 * @subpackage Services
 */
class Enviosms extends AbstractSoapClientBase
{
    /**
     * Method to call the operation originally named enviosms
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \mensajeriabonos\StructType\Enviosms $parameters
     * @return \mensajeriabonos\StructType\EnviosmsResponse|bool
     */
    public function enviosms(\mensajeriabonos\StructType\Enviosms $parameters)
    {
        try {
            $this->setResult($this->getSoapClient()->enviosms($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named enviosmsSimple
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \mensajeriabonos\StructType\EnviosmsSimple $parameters
     * @return \mensajeriabonos\StructType\EnviosmsSimpleResponse|bool
     */
    public function enviosmsSimple(\mensajeriabonos\StructType\EnviosmsSimple $parameters)
    {
        try {
            $this->setResult($this->getSoapClient()->enviosmsSimple($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Returns the result
     * @see AbstractSoapClientBase::getResult()
     * @return \mensajeriabonos\StructType\EnviosmsResponse|\mensajeriabonos\StructType\EnviosmsSimpleResponse
     */
    public function getResult()
    {
        return parent::getResult();
    }
}
