<?php

namespace Stuba\StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for TransferAvailabilityResultElement StructType
 * @subpackage Structs
 */
class TransferAvailabilityResultElement extends AbstractStructBase
{
    /**
     * The TransferDirection
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var string
     */
    public $TransferDirection;
    /**
     * The VehicleCount
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var int
     */
    public $VehicleCount;
    /**
     * The Confirmation
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var string
     */
    public $Confirmation;
    /**
     * The QuoteId
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $QuoteId;
    /**
     * The Supplier
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $Supplier;
    /**
     * The VehicleType
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $VehicleType;
    /**
     * The OutboundDateTime
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $OutboundDateTime;
    /**
     * The InboundDateTime
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $InboundDateTime;
    /**
     * The Guests
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \Stuba\StructType\ArrayOfChoice4
     */
    public $Guests;
    /**
     * The SellingPrice
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \Stuba\StructType\MoneyElement
     */
    public $SellingPrice;
    /**
     * The BuyingPrice
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \Stuba\StructType\MoneyElement
     */
    public $BuyingPrice;
    /**
     * The CanxFees
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \Stuba\ArrayType\ArrayOfFeeElement
     */
    public $CanxFees;
    /**
     * The RequiredBookingInformation
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \Stuba\StructType\RequiredBookingInformationElement
     */
    public $RequiredBookingInformation;
    /**
     * Constructor method for TransferAvailabilityResultElement
     * @uses TransferAvailabilityResultElement::setTransferDirection()
     * @uses TransferAvailabilityResultElement::setVehicleCount()
     * @uses TransferAvailabilityResultElement::setConfirmation()
     * @uses TransferAvailabilityResultElement::setQuoteId()
     * @uses TransferAvailabilityResultElement::setSupplier()
     * @uses TransferAvailabilityResultElement::setVehicleType()
     * @uses TransferAvailabilityResultElement::setOutboundDateTime()
     * @uses TransferAvailabilityResultElement::setInboundDateTime()
     * @uses TransferAvailabilityResultElement::setGuests()
     * @uses TransferAvailabilityResultElement::setSellingPrice()
     * @uses TransferAvailabilityResultElement::setBuyingPrice()
     * @uses TransferAvailabilityResultElement::setCanxFees()
     * @uses TransferAvailabilityResultElement::setRequiredBookingInformation()
     * @param string $transferDirection
     * @param int $vehicleCount
     * @param string $confirmation
     * @param string $quoteId
     * @param string $supplier
     * @param string $vehicleType
     * @param string $outboundDateTime
     * @param string $inboundDateTime
     * @param \Stuba\StructType\ArrayOfChoice4 $guests
     * @param \Stuba\StructType\MoneyElement $sellingPrice
     * @param \Stuba\StructType\MoneyElement $buyingPrice
     * @param \Stuba\ArrayType\ArrayOfFeeElement $canxFees
     * @param \Stuba\StructType\RequiredBookingInformationElement $requiredBookingInformation
     */
    public function __construct($transferDirection = null, $vehicleCount = null, $confirmation = null, $quoteId = null, $supplier = null, $vehicleType = null, $outboundDateTime = null, $inboundDateTime = null, \Stuba\StructType\ArrayOfChoice4 $guests = null, \Stuba\StructType\MoneyElement $sellingPrice = null, \Stuba\StructType\MoneyElement $buyingPrice = null, \Stuba\ArrayType\ArrayOfFeeElement $canxFees = null, \Stuba\StructType\RequiredBookingInformationElement $requiredBookingInformation = null)
    {
        $this
            ->setTransferDirection($transferDirection)
            ->setVehicleCount($vehicleCount)
            ->setConfirmation($confirmation)
            ->setQuoteId($quoteId)
            ->setSupplier($supplier)
            ->setVehicleType($vehicleType)
            ->setOutboundDateTime($outboundDateTime)
            ->setInboundDateTime($inboundDateTime)
            ->setGuests($guests)
            ->setSellingPrice($sellingPrice)
            ->setBuyingPrice($buyingPrice)
            ->setCanxFees($canxFees)
            ->setRequiredBookingInformation($requiredBookingInformation);
    }
    /**
     * Get TransferDirection value
     * @return string
     */
    public function getTransferDirection()
    {
        return $this->TransferDirection;
    }
    /**
     * Set TransferDirection value
     * @param string $transferDirection
     * @return \Stuba\StructType\TransferAvailabilityResultElement
     */
    public function setTransferDirection($transferDirection = null)
    {
        $this->TransferDirection = $transferDirection;
        return $this;
    }
    /**
     * Get VehicleCount value
     * @return int
     */
    public function getVehicleCount()
    {
        return $this->VehicleCount;
    }
    /**
     * Set VehicleCount value
     * @param int $vehicleCount
     * @return \Stuba\StructType\TransferAvailabilityResultElement
     */
    public function setVehicleCount($vehicleCount = null)
    {
        $this->VehicleCount = $vehicleCount;
        return $this;
    }
    /**
     * Get Confirmation value
     * @return string
     */
    public function getConfirmation()
    {
        return $this->Confirmation;
    }
    /**
     * Set Confirmation value
     * @param string $confirmation
     * @return \Stuba\StructType\TransferAvailabilityResultElement
     */
    public function setConfirmation($confirmation = null)
    {
        $this->Confirmation = $confirmation;
        return $this;
    }
    /**
     * Get QuoteId value
     * @return string|null
     */
    public function getQuoteId()
    {
        return $this->QuoteId;
    }
    /**
     * Set QuoteId value
     * @param string $quoteId
     * @return \Stuba\StructType\TransferAvailabilityResultElement
     */
    public function setQuoteId($quoteId = null)
    {
        $this->QuoteId = $quoteId;
        return $this;
    }
    /**
     * Get Supplier value
     * @return string|null
     */
    public function getSupplier()
    {
        return $this->Supplier;
    }
    /**
     * Set Supplier value
     * @param string $supplier
     * @return \Stuba\StructType\TransferAvailabilityResultElement
     */
    public function setSupplier($supplier = null)
    {
        $this->Supplier = $supplier;
        return $this;
    }
    /**
     * Get VehicleType value
     * @return string|null
     */
    public function getVehicleType()
    {
        return $this->VehicleType;
    }
    /**
     * Set VehicleType value
     * @param string $vehicleType
     * @return \Stuba\StructType\TransferAvailabilityResultElement
     */
    public function setVehicleType($vehicleType = null)
    {
        $this->VehicleType = $vehicleType;
        return $this;
    }
    /**
     * Get OutboundDateTime value
     * @return string|null
     */
    public function getOutboundDateTime()
    {
        return $this->OutboundDateTime;
    }
    /**
     * Set OutboundDateTime value
     * @param string $outboundDateTime
     * @return \Stuba\StructType\TransferAvailabilityResultElement
     */
    public function setOutboundDateTime($outboundDateTime = null)
    {
        $this->OutboundDateTime = $outboundDateTime;
        return $this;
    }
    /**
     * Get InboundDateTime value
     * @return string|null
     */
    public function getInboundDateTime()
    {
        return $this->InboundDateTime;
    }
    /**
     * Set InboundDateTime value
     * @param string $inboundDateTime
     * @return \Stuba\StructType\TransferAvailabilityResultElement
     */
    public function setInboundDateTime($inboundDateTime = null)
    {
        $this->InboundDateTime = $inboundDateTime;
        return $this;
    }
    /**
     * Get Guests value
     * @return \Stuba\StructType\ArrayOfChoice4|null
     */
    public function getGuests()
    {
        return $this->Guests;
    }
    /**
     * Set Guests value
     * @param \Stuba\StructType\ArrayOfChoice4 $guests
     * @return \Stuba\StructType\TransferAvailabilityResultElement
     */
    public function setGuests(\Stuba\StructType\ArrayOfChoice4 $guests = null)
    {
        $this->Guests = $guests;
        return $this;
    }
    /**
     * Get SellingPrice value
     * @return \Stuba\StructType\MoneyElement|null
     */
    public function getSellingPrice()
    {
        return $this->SellingPrice;
    }
    /**
     * Set SellingPrice value
     * @param \Stuba\StructType\MoneyElement $sellingPrice
     * @return \Stuba\StructType\TransferAvailabilityResultElement
     */
    public function setSellingPrice(\Stuba\StructType\MoneyElement $sellingPrice = null)
    {
        $this->SellingPrice = $sellingPrice;
        return $this;
    }
    /**
     * Get BuyingPrice value
     * @return \Stuba\StructType\MoneyElement|null
     */
    public function getBuyingPrice()
    {
        return $this->BuyingPrice;
    }
    /**
     * Set BuyingPrice value
     * @param \Stuba\StructType\MoneyElement $buyingPrice
     * @return \Stuba\StructType\TransferAvailabilityResultElement
     */
    public function setBuyingPrice(\Stuba\StructType\MoneyElement $buyingPrice = null)
    {
        $this->BuyingPrice = $buyingPrice;
        return $this;
    }
    /**
     * Get CanxFees value
     * @return \Stuba\ArrayType\ArrayOfFeeElement|null
     */
    public function getCanxFees()
    {
        return $this->CanxFees;
    }
    /**
     * Set CanxFees value
     * @param \Stuba\ArrayType\ArrayOfFeeElement $canxFees
     * @return \Stuba\StructType\TransferAvailabilityResultElement
     */
    public function setCanxFees(\Stuba\ArrayType\ArrayOfFeeElement $canxFees = null)
    {
        $this->CanxFees = $canxFees;
        return $this;
    }
    /**
     * Get RequiredBookingInformation value
     * @return \Stuba\StructType\RequiredBookingInformationElement|null
     */
    public function getRequiredBookingInformation()
    {
        return $this->RequiredBookingInformation;
    }
    /**
     * Set RequiredBookingInformation value
     * @param \Stuba\StructType\RequiredBookingInformationElement $requiredBookingInformation
     * @return \Stuba\StructType\TransferAvailabilityResultElement
     */
    public function setRequiredBookingInformation(\Stuba\StructType\RequiredBookingInformationElement $requiredBookingInformation = null)
    {
        $this->RequiredBookingInformation = $requiredBookingInformation;
        return $this;
    }
}
