<?php

namespace Stuba\StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for HotelStayDetailsElement StructType
 * @subpackage Structs
 */
class HotelStayDetailsElement extends AbstractStructBase
{
    /**
     * The ArrivalDate
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var string
     */
    public $ArrivalDate;
    /**
     * The Nights
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var int
     */
    public $Nights;
    /**
     * The Room
     * Meta information extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * @var \Stuba\StructType\HotelStayDetailsRoomElement[]
     */
    public $Room;
    /**
     * The Nationality
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $Nationality;
    /**
     * Constructor method for HotelStayDetailsElement
     * @uses HotelStayDetailsElement::setArrivalDate()
     * @uses HotelStayDetailsElement::setNights()
     * @uses HotelStayDetailsElement::setRoom()
     * @uses HotelStayDetailsElement::setNationality()
     * @param string $arrivalDate
     * @param int $nights
     * @param \Stuba\StructType\HotelStayDetailsRoomElement[] $room
     * @param string $nationality
     */
    public function __construct($arrivalDate = null, $nights = null, array $room = array(), $nationality = null)
    {
        $this
            ->setArrivalDate($arrivalDate)
            ->setNights($nights)
            ->setRoom($room)
            ->setNationality($nationality);
    }
    /**
     * Get ArrivalDate value
     * @return string
     */
    public function getArrivalDate()
    {
        return $this->ArrivalDate;
    }
    /**
     * Set ArrivalDate value
     * @param string $arrivalDate
     * @return \Stuba\StructType\HotelStayDetailsElement
     */
    public function setArrivalDate($arrivalDate = null)
    {
        $this->ArrivalDate = $arrivalDate;
        return $this;
    }
    /**
     * Get Nights value
     * @return int
     */
    public function getNights()
    {
        return $this->Nights;
    }
    /**
     * Set Nights value
     * @param int $nights
     * @return \Stuba\StructType\HotelStayDetailsElement
     */
    public function setNights($nights = null)
    {
        $this->Nights = $nights;
        return $this;
    }
    /**
     * Get Room value
     * @return \Stuba\StructType\HotelStayDetailsRoomElement[]|null
     */
    public function getRoom()
    {
        return $this->Room;
    }
    /**
     * Set Room value
     * @param \Stuba\StructType\HotelStayDetailsRoomElement[] $room
     * @return \Stuba\StructType\HotelStayDetailsElement
     */
    public function setRoom(array $room = array())
    {
        $this->Room = $room;
        return $this;
    }
    /**
     * Add item to Room value
     * @throws \InvalidArgumentException
     * @param \Stuba\StructType\HotelStayDetailsRoomElement $item
     * @return \Stuba\StructType\HotelStayDetailsElement
     */
    public function addToRoom(\Stuba\StructType\HotelStayDetailsRoomElement $item)
    {
        $this->Room[] = $item;
        return $this;
    }
    /**
     * Get Nationality value
     * @return string|null
     */
    public function getNationality()
    {
        return $this->Nationality;
    }
    /**
     * Set Nationality value
     * @param string $nationality
     * @return \Stuba\StructType\HotelStayDetailsElement
     */
    public function setNationality($nationality = null)
    {
        $this->Nationality = $nationality;
        return $this;
    }
}
