<?php

namespace Stuba\ServiceType;

use \WsdlToPhp\PackageBase\AbstractSoapClientBase;

/**
 * This class stands for Availability ServiceType
 * @subpackage Services
 */
class Availability extends AbstractSoapClientBase
{
    /**
     * Method to call the operation originally named AvailabilitySearch
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \Stuba\StructType\AvailabilitySearch $parameters
     * @return \Stuba\StructType\AvailabilitySearchResponse|bool
     */
    public function AvailabilitySearch(\Stuba\StructType\AvailabilitySearch $parameters)
    {
        try {
            $this->setResult($this->getSoapClient()->AvailabilitySearch($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Returns the result
     * @see AbstractSoapClientBase::getResult()
     * @return \Stuba\StructType\AvailabilitySearchResponse
     */
    public function getResult()
    {
        return parent::getResult();
    }
}
