<?php

namespace Stuba\StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for TransferRouteSupplierInfoElement StructType
 * @subpackage Structs
 */
class TransferRouteSupplierInfoElement extends AbstractStructBase
{
    /**
     * The IsSingleSupported
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var bool
     */
    public $IsSingleSupported;
    /**
     * The IsReturnSupported
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var bool
     */
    public $IsReturnSupported;
    /**
     * The Supplier
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $Supplier;
    /**
     * The SupplierCode
     * Meta information extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * @var \Stuba\StructType\SupplierCodeElement[]
     */
    public $SupplierCode;
    /**
     * Constructor method for TransferRouteSupplierInfoElement
     * @uses TransferRouteSupplierInfoElement::setIsSingleSupported()
     * @uses TransferRouteSupplierInfoElement::setIsReturnSupported()
     * @uses TransferRouteSupplierInfoElement::setSupplier()
     * @uses TransferRouteSupplierInfoElement::setSupplierCode()
     * @param bool $isSingleSupported
     * @param bool $isReturnSupported
     * @param string $supplier
     * @param \Stuba\StructType\SupplierCodeElement[] $supplierCode
     */
    public function __construct($isSingleSupported = null, $isReturnSupported = null, $supplier = null, array $supplierCode = array())
    {
        $this
            ->setIsSingleSupported($isSingleSupported)
            ->setIsReturnSupported($isReturnSupported)
            ->setSupplier($supplier)
            ->setSupplierCode($supplierCode);
    }
    /**
     * Get IsSingleSupported value
     * @return bool
     */
    public function getIsSingleSupported()
    {
        return $this->IsSingleSupported;
    }
    /**
     * Set IsSingleSupported value
     * @param bool $isSingleSupported
     * @return \Stuba\StructType\TransferRouteSupplierInfoElement
     */
    public function setIsSingleSupported($isSingleSupported = null)
    {
        $this->IsSingleSupported = $isSingleSupported;
        return $this;
    }
    /**
     * Get IsReturnSupported value
     * @return bool
     */
    public function getIsReturnSupported()
    {
        return $this->IsReturnSupported;
    }
    /**
     * Set IsReturnSupported value
     * @param bool $isReturnSupported
     * @return \Stuba\StructType\TransferRouteSupplierInfoElement
     */
    public function setIsReturnSupported($isReturnSupported = null)
    {
        $this->IsReturnSupported = $isReturnSupported;
        return $this;
    }
    /**
     * Get Supplier value
     * @return string|null
     */
    public function getSupplier()
    {
        return $this->Supplier;
    }
    /**
     * Set Supplier value
     * @param string $supplier
     * @return \Stuba\StructType\TransferRouteSupplierInfoElement
     */
    public function setSupplier($supplier = null)
    {
        $this->Supplier = $supplier;
        return $this;
    }
    /**
     * Get SupplierCode value
     * @return \Stuba\StructType\SupplierCodeElement[]|null
     */
    public function getSupplierCode()
    {
        return $this->SupplierCode;
    }
    /**
     * Set SupplierCode value
     * @param \Stuba\StructType\SupplierCodeElement[] $supplierCode
     * @return \Stuba\StructType\TransferRouteSupplierInfoElement
     */
    public function setSupplierCode(array $supplierCode = array())
    {
        $this->SupplierCode = $supplierCode;
        return $this;
    }
    /**
     * Add item to SupplierCode value
     * @throws \InvalidArgumentException
     * @param \Stuba\StructType\SupplierCodeElement $item
     * @return \Stuba\StructType\TransferRouteSupplierInfoElement
     */
    public function addToSupplierCode(\Stuba\StructType\SupplierCodeElement $item)
    {
        $this->SupplierCode[] = $item;
        return $this;
    }
}
