<?php

namespace Stuba\StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for TransferRouteElement StructType
 * @subpackage Structs
 */
class TransferRouteElement extends AbstractStructBase
{
    /**
     * The Id
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var int
     */
    public $Id;
    /**
     * The IsSingleSupported
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var bool
     */
    public $IsSingleSupported;
    /**
     * The IsReturnSupported
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var bool
     */
    public $IsReturnSupported;
    /**
     * The PickupPoint
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \Stuba\StructType\EndPoint
     */
    public $PickupPoint;
    /**
     * The DestinationPoint
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \Stuba\StructType\EndPoint
     */
    public $DestinationPoint;
    /**
     * The SupplierInfo
     * Meta information extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * @var \Stuba\StructType\TransferRouteSupplierInfoElement[]
     */
    public $SupplierInfo;
    /**
     * Constructor method for TransferRouteElement
     * @uses TransferRouteElement::setId()
     * @uses TransferRouteElement::setIsSingleSupported()
     * @uses TransferRouteElement::setIsReturnSupported()
     * @uses TransferRouteElement::setPickupPoint()
     * @uses TransferRouteElement::setDestinationPoint()
     * @uses TransferRouteElement::setSupplierInfo()
     * @param int $id
     * @param bool $isSingleSupported
     * @param bool $isReturnSupported
     * @param \Stuba\StructType\EndPoint $pickupPoint
     * @param \Stuba\StructType\EndPoint $destinationPoint
     * @param \Stuba\StructType\TransferRouteSupplierInfoElement[] $supplierInfo
     */
    public function __construct($id = null, $isSingleSupported = null, $isReturnSupported = null, \Stuba\StructType\EndPoint $pickupPoint = null, \Stuba\StructType\EndPoint $destinationPoint = null, array $supplierInfo = array())
    {
        $this
            ->setId($id)
            ->setIsSingleSupported($isSingleSupported)
            ->setIsReturnSupported($isReturnSupported)
            ->setPickupPoint($pickupPoint)
            ->setDestinationPoint($destinationPoint)
            ->setSupplierInfo($supplierInfo);
    }
    /**
     * Get Id value
     * @return int
     */
    public function getId()
    {
        return $this->Id;
    }
    /**
     * Set Id value
     * @param int $id
     * @return \Stuba\StructType\TransferRouteElement
     */
    public function setId($id = null)
    {
        $this->Id = $id;
        return $this;
    }
    /**
     * Get IsSingleSupported value
     * @return bool
     */
    public function getIsSingleSupported()
    {
        return $this->IsSingleSupported;
    }
    /**
     * Set IsSingleSupported value
     * @param bool $isSingleSupported
     * @return \Stuba\StructType\TransferRouteElement
     */
    public function setIsSingleSupported($isSingleSupported = null)
    {
        $this->IsSingleSupported = $isSingleSupported;
        return $this;
    }
    /**
     * Get IsReturnSupported value
     * @return bool
     */
    public function getIsReturnSupported()
    {
        return $this->IsReturnSupported;
    }
    /**
     * Set IsReturnSupported value
     * @param bool $isReturnSupported
     * @return \Stuba\StructType\TransferRouteElement
     */
    public function setIsReturnSupported($isReturnSupported = null)
    {
        $this->IsReturnSupported = $isReturnSupported;
        return $this;
    }
    /**
     * Get PickupPoint value
     * @return \Stuba\StructType\EndPoint|null
     */
    public function getPickupPoint()
    {
        return $this->PickupPoint;
    }
    /**
     * Set PickupPoint value
     * @param \Stuba\StructType\EndPoint $pickupPoint
     * @return \Stuba\StructType\TransferRouteElement
     */
    public function setPickupPoint(\Stuba\StructType\EndPoint $pickupPoint = null)
    {
        $this->PickupPoint = $pickupPoint;
        return $this;
    }
    /**
     * Get DestinationPoint value
     * @return \Stuba\StructType\EndPoint|null
     */
    public function getDestinationPoint()
    {
        return $this->DestinationPoint;
    }
    /**
     * Set DestinationPoint value
     * @param \Stuba\StructType\EndPoint $destinationPoint
     * @return \Stuba\StructType\TransferRouteElement
     */
    public function setDestinationPoint(\Stuba\StructType\EndPoint $destinationPoint = null)
    {
        $this->DestinationPoint = $destinationPoint;
        return $this;
    }
    /**
     * Get SupplierInfo value
     * @return \Stuba\StructType\TransferRouteSupplierInfoElement[]|null
     */
    public function getSupplierInfo()
    {
        return $this->SupplierInfo;
    }
    /**
     * Set SupplierInfo value
     * @param \Stuba\StructType\TransferRouteSupplierInfoElement[] $supplierInfo
     * @return \Stuba\StructType\TransferRouteElement
     */
    public function setSupplierInfo(array $supplierInfo = array())
    {
        $this->SupplierInfo = $supplierInfo;
        return $this;
    }
    /**
     * Add item to SupplierInfo value
     * @throws \InvalidArgumentException
     * @param \Stuba\StructType\TransferRouteSupplierInfoElement $item
     * @return \Stuba\StructType\TransferRouteElement
     */
    public function addToSupplierInfo(\Stuba\StructType\TransferRouteSupplierInfoElement $item)
    {
        $this->SupplierInfo[] = $item;
        return $this;
    }
}
