<?php

namespace Stuba\StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for PaymentElement StructType
 * @subpackage Structs
 */
class PaymentElement extends AbstractStructBase
{
    /**
     * The Id
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var int
     */
    public $Id;
    /**
     * The ParentId
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var int
     */
    public $ParentId;
    /**
     * The PaymentDate
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var string
     */
    public $PaymentDate;
    /**
     * The PaymentType
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \Stuba\StructType\TextEnumPair
     */
    public $PaymentType;
    /**
     * The CardDigits
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $CardDigits;
    /**
     * The Currency
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $Currency;
    /**
     * The Amount
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \Stuba\StructType\MoneyElement
     */
    public $Amount;
    /**
     * The Fee
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \Stuba\StructType\MoneyElement
     */
    public $Fee;
    /**
     * Constructor method for PaymentElement
     * @uses PaymentElement::setId()
     * @uses PaymentElement::setParentId()
     * @uses PaymentElement::setPaymentDate()
     * @uses PaymentElement::setPaymentType()
     * @uses PaymentElement::setCardDigits()
     * @uses PaymentElement::setCurrency()
     * @uses PaymentElement::setAmount()
     * @uses PaymentElement::setFee()
     * @param int $id
     * @param int $parentId
     * @param string $paymentDate
     * @param \Stuba\StructType\TextEnumPair $paymentType
     * @param string $cardDigits
     * @param string $currency
     * @param \Stuba\StructType\MoneyElement $amount
     * @param \Stuba\StructType\MoneyElement $fee
     */
    public function __construct($id = null, $parentId = null, $paymentDate = null, \Stuba\StructType\TextEnumPair $paymentType = null, $cardDigits = null, $currency = null, \Stuba\StructType\MoneyElement $amount = null, \Stuba\StructType\MoneyElement $fee = null)
    {
        $this
            ->setId($id)
            ->setParentId($parentId)
            ->setPaymentDate($paymentDate)
            ->setPaymentType($paymentType)
            ->setCardDigits($cardDigits)
            ->setCurrency($currency)
            ->setAmount($amount)
            ->setFee($fee);
    }
    /**
     * Get Id value
     * @return int
     */
    public function getId()
    {
        return $this->Id;
    }
    /**
     * Set Id value
     * @param int $id
     * @return \Stuba\StructType\PaymentElement
     */
    public function setId($id = null)
    {
        $this->Id = $id;
        return $this;
    }
    /**
     * Get ParentId value
     * @return int
     */
    public function getParentId()
    {
        return $this->ParentId;
    }
    /**
     * Set ParentId value
     * @param int $parentId
     * @return \Stuba\StructType\PaymentElement
     */
    public function setParentId($parentId = null)
    {
        $this->ParentId = $parentId;
        return $this;
    }
    /**
     * Get PaymentDate value
     * @return string
     */
    public function getPaymentDate()
    {
        return $this->PaymentDate;
    }
    /**
     * Set PaymentDate value
     * @param string $paymentDate
     * @return \Stuba\StructType\PaymentElement
     */
    public function setPaymentDate($paymentDate = null)
    {
        $this->PaymentDate = $paymentDate;
        return $this;
    }
    /**
     * Get PaymentType value
     * @return \Stuba\StructType\TextEnumPair|null
     */
    public function getPaymentType()
    {
        return $this->PaymentType;
    }
    /**
     * Set PaymentType value
     * @param \Stuba\StructType\TextEnumPair $paymentType
     * @return \Stuba\StructType\PaymentElement
     */
    public function setPaymentType(\Stuba\StructType\TextEnumPair $paymentType = null)
    {
        $this->PaymentType = $paymentType;
        return $this;
    }
    /**
     * Get CardDigits value
     * @return string|null
     */
    public function getCardDigits()
    {
        return $this->CardDigits;
    }
    /**
     * Set CardDigits value
     * @param string $cardDigits
     * @return \Stuba\StructType\PaymentElement
     */
    public function setCardDigits($cardDigits = null)
    {
        $this->CardDigits = $cardDigits;
        return $this;
    }
    /**
     * Get Currency value
     * @return string|null
     */
    public function getCurrency()
    {
        return $this->Currency;
    }
    /**
     * Set Currency value
     * @param string $currency
     * @return \Stuba\StructType\PaymentElement
     */
    public function setCurrency($currency = null)
    {
        $this->Currency = $currency;
        return $this;
    }
    /**
     * Get Amount value
     * @return \Stuba\StructType\MoneyElement|null
     */
    public function getAmount()
    {
        return $this->Amount;
    }
    /**
     * Set Amount value
     * @param \Stuba\StructType\MoneyElement $amount
     * @return \Stuba\StructType\PaymentElement
     */
    public function setAmount(\Stuba\StructType\MoneyElement $amount = null)
    {
        $this->Amount = $amount;
        return $this;
    }
    /**
     * Get Fee value
     * @return \Stuba\StructType\MoneyElement|null
     */
    public function getFee()
    {
        return $this->Fee;
    }
    /**
     * Set Fee value
     * @param \Stuba\StructType\MoneyElement $fee
     * @return \Stuba\StructType\PaymentElement
     */
    public function setFee(\Stuba\StructType\MoneyElement $fee = null)
    {
        $this->Fee = $fee;
        return $this;
    }
}
