<?php

namespace Stuba\StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for HotelAvailabilityResultElement StructType
 * @subpackage Structs
 */
class HotelAvailabilityResultElement extends AbstractStructBase
{
    /**
     * The QuoteId
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $QuoteId;
    /**
     * The Room
     * Meta information extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * @var \Stuba\StructType\HotelAvailabilityRoomElement[]
     */
    public $Room;
    /**
     * The id
     * @var string
     */
    public $id;
    /**
     * Constructor method for HotelAvailabilityResultElement
     * @uses HotelAvailabilityResultElement::setQuoteId()
     * @uses HotelAvailabilityResultElement::setRoom()
     * @uses HotelAvailabilityResultElement::setId()
     * @param string $quoteId
     * @param \Stuba\StructType\HotelAvailabilityRoomElement[] $room
     * @param string $id
     */
    public function __construct($quoteId = null, array $room = array(), $id = null)
    {
        $this
            ->setQuoteId($quoteId)
            ->setRoom($room)
            ->setId($id);
    }
    /**
     * Get QuoteId value
     * @return string|null
     */
    public function getQuoteId()
    {
        return $this->QuoteId;
    }
    /**
     * Set QuoteId value
     * @param string $quoteId
     * @return \Stuba\StructType\HotelAvailabilityResultElement
     */
    public function setQuoteId($quoteId = null)
    {
        $this->QuoteId = $quoteId;
        return $this;
    }
    /**
     * Get Room value
     * @return \Stuba\StructType\HotelAvailabilityRoomElement[]|null
     */
    public function getRoom()
    {
        return $this->Room;
    }
    /**
     * Set Room value
     * @param \Stuba\StructType\HotelAvailabilityRoomElement[] $room
     * @return \Stuba\StructType\HotelAvailabilityResultElement
     */
    public function setRoom(array $room = array())
    {
        $this->Room = $room;
        return $this;
    }
    /**
     * Add item to Room value
     * @throws \InvalidArgumentException
     * @param \Stuba\StructType\HotelAvailabilityRoomElement $item
     * @return \Stuba\StructType\HotelAvailabilityResultElement
     */
    public function addToRoom(\Stuba\StructType\HotelAvailabilityRoomElement $item)
    {
        $this->Room[] = $item;
        return $this;
    }
    /**
     * Get id value
     * @return string|null
     */
    public function getId()
    {
        return $this->id;
    }
    /**
     * Set id value
     * @param string $id
     * @return \Stuba\StructType\HotelAvailabilityResultElement
     */
    public function setId($id = null)
    {
        $this->id = $id;
        return $this;
    }
}
