<?php

namespace Stuba\StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for BookingAmendResult StructType
 * @subpackage Structs
 */
class BookingAmendResult extends ResponseBase
{
    /**
     * The CommitLevel
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $CommitLevel;
    /**
     * The Booking
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \Stuba\StructType\BookingElement
     */
    public $Booking;
    /**
     * Constructor method for BookingAmendResult
     * @uses BookingAmendResult::setCommitLevel()
     * @uses BookingAmendResult::setBooking()
     * @param string $commitLevel
     * @param \Stuba\StructType\BookingElement $booking
     */
    public function __construct($commitLevel = null, \Stuba\StructType\BookingElement $booking = null)
    {
        $this
            ->setCommitLevel($commitLevel)
            ->setBooking($booking);
    }
    /**
     * Get CommitLevel value
     * @return string|null
     */
    public function getCommitLevel()
    {
        return $this->CommitLevel;
    }
    /**
     * Set CommitLevel value
     * @param string $commitLevel
     * @return \Stuba\StructType\BookingAmendResult
     */
    public function setCommitLevel($commitLevel = null)
    {
        $this->CommitLevel = $commitLevel;
        return $this;
    }
    /**
     * Get Booking value
     * @return \Stuba\StructType\BookingElement|null
     */
    public function getBooking()
    {
        return $this->Booking;
    }
    /**
     * Set Booking value
     * @param \Stuba\StructType\BookingElement $booking
     * @return \Stuba\StructType\BookingAmendResult
     */
    public function setBooking(\Stuba\StructType\BookingElement $booking = null)
    {
        $this->Booking = $booking;
        return $this;
    }
}
