<?php

namespace Stuba\StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for BookingAmend StructType
 * @subpackage Structs
 */
class BookingAmend extends AbstractStructBase
{
    /**
     * The Id
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var int
     */
    public $Id;
    /**
     * The OldCustomerId
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var int
     */
    public $OldCustomerId;
    /**
     * The NewCustomerId
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var int
     */
    public $NewCustomerId;
    /**
     * The DetailLevel
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var string
     */
    public $DetailLevel;
    /**
     * The xiRequest
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \Stuba\StructType\BookingAmend
     */
    public $xiRequest;
    /**
     * The Authority
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \Stuba\StructType\AuthorityElement
     */
    public $Authority;
    /**
     * The EditHotelBooking
     * Meta information extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * @var \Stuba\StructType\EditHotelBookingElement[]
     */
    public $EditHotelBooking;
    /**
     * The CommitLevel
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $CommitLevel;
    /**
     * The AddHotelBooking
     * Meta information extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * @var \Stuba\StructType\CreateBookingElement[]
     */
    public $AddHotelBooking;
    /**
     * The CancelHotelBooking
     * Meta information extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * @var int[]
     */
    public $CancelHotelBooking;
    /**
     * The AddTransferBooking
     * Meta information extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * @var \Stuba\StructType\CreateTransferBookingElement[]
     */
    public $AddTransferBooking;
    /**
     * The CancelTransferBooking
     * Meta information extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * @var int[]
     */
    public $CancelTransferBooking;
    /**
     * The PaymentDetails
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \Stuba\StructType\PaymentDetailsElement
     */
    public $PaymentDetails;
    /**
     * Constructor method for BookingAmend
     * @uses BookingAmend::setId()
     * @uses BookingAmend::setOldCustomerId()
     * @uses BookingAmend::setNewCustomerId()
     * @uses BookingAmend::setDetailLevel()
     * @uses BookingAmend::setXiRequest()
     * @uses BookingAmend::setAuthority()
     * @uses BookingAmend::setEditHotelBooking()
     * @uses BookingAmend::setCommitLevel()
     * @uses BookingAmend::setAddHotelBooking()
     * @uses BookingAmend::setCancelHotelBooking()
     * @uses BookingAmend::setAddTransferBooking()
     * @uses BookingAmend::setCancelTransferBooking()
     * @uses BookingAmend::setPaymentDetails()
     * @param int $id
     * @param int $oldCustomerId
     * @param int $newCustomerId
     * @param string $detailLevel
     * @param \Stuba\StructType\BookingAmend $xiRequest
     * @param \Stuba\StructType\AuthorityElement $authority
     * @param \Stuba\StructType\EditHotelBookingElement[] $editHotelBooking
     * @param string $commitLevel
     * @param \Stuba\StructType\CreateBookingElement[] $addHotelBooking
     * @param int[] $cancelHotelBooking
     * @param \Stuba\StructType\CreateTransferBookingElement[] $addTransferBooking
     * @param int[] $cancelTransferBooking
     * @param \Stuba\StructType\PaymentDetailsElement $paymentDetails
     */
    public function __construct($id = null, $oldCustomerId = null, $newCustomerId = null, $detailLevel = null, \Stuba\StructType\BookingAmend $xiRequest = null, \Stuba\StructType\AuthorityElement $authority = null, array $editHotelBooking = array(), $commitLevel = null, array $addHotelBooking = array(), array $cancelHotelBooking = array(), array $addTransferBooking = array(), array $cancelTransferBooking = array(), \Stuba\StructType\PaymentDetailsElement $paymentDetails = null)
    {
        $this
            ->setId($id)
            ->setOldCustomerId($oldCustomerId)
            ->setNewCustomerId($newCustomerId)
            ->setDetailLevel($detailLevel)
            ->setXiRequest($xiRequest)
            ->setAuthority($authority)
            ->setEditHotelBooking($editHotelBooking)
            ->setCommitLevel($commitLevel)
            ->setAddHotelBooking($addHotelBooking)
            ->setCancelHotelBooking($cancelHotelBooking)
            ->setAddTransferBooking($addTransferBooking)
            ->setCancelTransferBooking($cancelTransferBooking)
            ->setPaymentDetails($paymentDetails);
    }
    /**
     * Get Id value
     * @return int
     */
    public function getId()
    {
        return $this->Id;
    }
    /**
     * Set Id value
     * @param int $id
     * @return \Stuba\StructType\BookingAmend
     */
    public function setId($id = null)
    {
        $this->Id = $id;
        return $this;
    }
    /**
     * Get OldCustomerId value
     * @return int
     */
    public function getOldCustomerId()
    {
        return $this->OldCustomerId;
    }
    /**
     * Set OldCustomerId value
     * @param int $oldCustomerId
     * @return \Stuba\StructType\BookingAmend
     */
    public function setOldCustomerId($oldCustomerId = null)
    {
        $this->OldCustomerId = $oldCustomerId;
        return $this;
    }
    /**
     * Get NewCustomerId value
     * @return int
     */
    public function getNewCustomerId()
    {
        return $this->NewCustomerId;
    }
    /**
     * Set NewCustomerId value
     * @param int $newCustomerId
     * @return \Stuba\StructType\BookingAmend
     */
    public function setNewCustomerId($newCustomerId = null)
    {
        $this->NewCustomerId = $newCustomerId;
        return $this;
    }
    /**
     * Get DetailLevel value
     * @return string
     */
    public function getDetailLevel()
    {
        return $this->DetailLevel;
    }
    /**
     * Set DetailLevel value
     * @param string $detailLevel
     * @return \Stuba\StructType\BookingAmend
     */
    public function setDetailLevel($detailLevel = null)
    {
        $this->DetailLevel = $detailLevel;
        return $this;
    }
    /**
     * Get xiRequest value
     * @return \Stuba\StructType\BookingAmend|null
     */
    public function getXiRequest()
    {
        return $this->xiRequest;
    }
    /**
     * Set xiRequest value
     * @param \Stuba\StructType\BookingAmend $xiRequest
     * @return \Stuba\StructType\BookingAmend
     */
    public function setXiRequest(\Stuba\StructType\BookingAmend $xiRequest = null)
    {
        $this->xiRequest = $xiRequest;
        return $this;
    }
    /**
     * Get Authority value
     * @return \Stuba\StructType\AuthorityElement|null
     */
    public function getAuthority()
    {
        return $this->Authority;
    }
    /**
     * Set Authority value
     * @param \Stuba\StructType\AuthorityElement $authority
     * @return \Stuba\StructType\BookingAmend
     */
    public function setAuthority(\Stuba\StructType\AuthorityElement $authority = null)
    {
        $this->Authority = $authority;
        return $this;
    }
    /**
     * Get EditHotelBooking value
     * @return \Stuba\StructType\EditHotelBookingElement[]|null
     */
    public function getEditHotelBooking()
    {
        return $this->EditHotelBooking;
    }
    /**
     * Set EditHotelBooking value
     * @param \Stuba\StructType\EditHotelBookingElement[] $editHotelBooking
     * @return \Stuba\StructType\BookingAmend
     */
    public function setEditHotelBooking(array $editHotelBooking = array())
    {
        $this->EditHotelBooking = $editHotelBooking;
        return $this;
    }
    /**
     * Add item to EditHotelBooking value
     * @throws \InvalidArgumentException
     * @param \Stuba\StructType\EditHotelBookingElement $item
     * @return \Stuba\StructType\BookingAmend
     */
    public function addToEditHotelBooking(\Stuba\StructType\EditHotelBookingElement $item)
    {
        $this->EditHotelBooking[] = $item;
        return $this;
    }
    /**
     * Get CommitLevel value
     * @return string|null
     */
    public function getCommitLevel()
    {
        return $this->CommitLevel;
    }
    /**
     * Set CommitLevel value
     * @param string $commitLevel
     * @return \Stuba\StructType\BookingAmend
     */
    public function setCommitLevel($commitLevel = null)
    {
        $this->CommitLevel = $commitLevel;
        return $this;
    }
    /**
     * Get AddHotelBooking value
     * @return \Stuba\StructType\CreateBookingElement[]|null
     */
    public function getAddHotelBooking()
    {
        return $this->AddHotelBooking;
    }
    /**
     * Set AddHotelBooking value
     * @param \Stuba\StructType\CreateBookingElement[] $addHotelBooking
     * @return \Stuba\StructType\BookingAmend
     */
    public function setAddHotelBooking(array $addHotelBooking = array())
    {
        $this->AddHotelBooking = $addHotelBooking;
        return $this;
    }
    /**
     * Add item to AddHotelBooking value
     * @throws \InvalidArgumentException
     * @param \Stuba\StructType\CreateBookingElement $item
     * @return \Stuba\StructType\BookingAmend
     */
    public function addToAddHotelBooking(\Stuba\StructType\CreateBookingElement $item)
    {
        $this->AddHotelBooking[] = $item;
        return $this;
    }
    /**
     * Get CancelHotelBooking value
     * @return int[]|null
     */
    public function getCancelHotelBooking()
    {
        return $this->CancelHotelBooking;
    }
    /**
     * Set CancelHotelBooking value
     * @param int[] $cancelHotelBooking
     * @return \Stuba\StructType\BookingAmend
     */
    public function setCancelHotelBooking(array $cancelHotelBooking = array())
    {
        $this->CancelHotelBooking = $cancelHotelBooking;
        return $this;
    }
    /**
     * Add item to CancelHotelBooking value
     * @throws \InvalidArgumentException
     * @param int $item
     * @return \Stuba\StructType\BookingAmend
     */
    public function addToCancelHotelBooking($item)
    {
        $this->CancelHotelBooking[] = $item;
        return $this;
    }
    /**
     * Get AddTransferBooking value
     * @return \Stuba\StructType\CreateTransferBookingElement[]|null
     */
    public function getAddTransferBooking()
    {
        return $this->AddTransferBooking;
    }
    /**
     * Set AddTransferBooking value
     * @param \Stuba\StructType\CreateTransferBookingElement[] $addTransferBooking
     * @return \Stuba\StructType\BookingAmend
     */
    public function setAddTransferBooking(array $addTransferBooking = array())
    {
        $this->AddTransferBooking = $addTransferBooking;
        return $this;
    }
    /**
     * Add item to AddTransferBooking value
     * @throws \InvalidArgumentException
     * @param \Stuba\StructType\CreateTransferBookingElement $item
     * @return \Stuba\StructType\BookingAmend
     */
    public function addToAddTransferBooking(\Stuba\StructType\CreateTransferBookingElement $item)
    {
        $this->AddTransferBooking[] = $item;
        return $this;
    }
    /**
     * Get CancelTransferBooking value
     * @return int[]|null
     */
    public function getCancelTransferBooking()
    {
        return $this->CancelTransferBooking;
    }
    /**
     * Set CancelTransferBooking value
     * @param int[] $cancelTransferBooking
     * @return \Stuba\StructType\BookingAmend
     */
    public function setCancelTransferBooking(array $cancelTransferBooking = array())
    {
        $this->CancelTransferBooking = $cancelTransferBooking;
        return $this;
    }
    /**
     * Add item to CancelTransferBooking value
     * @throws \InvalidArgumentException
     * @param int $item
     * @return \Stuba\StructType\BookingAmend
     */
    public function addToCancelTransferBooking($item)
    {
        $this->CancelTransferBooking[] = $item;
        return $this;
    }
    /**
     * Get PaymentDetails value
     * @return \Stuba\StructType\PaymentDetailsElement|null
     */
    public function getPaymentDetails()
    {
        return $this->PaymentDetails;
    }
    /**
     * Set PaymentDetails value
     * @param \Stuba\StructType\PaymentDetailsElement $paymentDetails
     * @return \Stuba\StructType\BookingAmend
     */
    public function setPaymentDetails(\Stuba\StructType\PaymentDetailsElement $paymentDetails = null)
    {
        $this->PaymentDetails = $paymentDetails;
        return $this;
    }
}
