<?php

namespace Stuba\StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for ArrayOfChoice6 StructType
 * @subpackage Structs
 */
class ArrayOfChoice6 extends AbstractStructBase
{
    /**
     * The Adult
     * Meta information extracted from the WSDL
     * - choice: Adult | Child
     * - choiceMaxOccurs: unbounded
     * - choiceMinOccurs: 0
     * - maxOccurs: 1
     * - minOccurs: 1
     * - nillable: true
     * @var \Stuba\StructType\AdultElement
     */
    public $Adult;
    /**
     * The Child
     * Meta information extracted from the WSDL
     * - choice: Adult | Child
     * - choiceMaxOccurs: unbounded
     * - choiceMinOccurs: 0
     * - maxOccurs: 1
     * - minOccurs: 1
     * - nillable: true
     * @var \Stuba\StructType\ChildElement
     */
    public $Child;
    /**
     * Constructor method for ArrayOfChoice6
     * @uses ArrayOfChoice6::setAdult()
     * @uses ArrayOfChoice6::setChild()
     * @param \Stuba\StructType\AdultElement $adult
     * @param \Stuba\StructType\ChildElement $child
     */
    public function __construct(\Stuba\StructType\AdultElement $adult = null, \Stuba\StructType\ChildElement $child = null)
    {
        $this
            ->setAdult($adult)
            ->setChild($child);
    }
    /**
     * Get Adult value
     * @return \Stuba\StructType\AdultElement
     */
    public function getAdult()
    {
        return isset($this->Adult) ? $this->Adult : null;
    }
    /**
     * Set Adult value
     * This property belongs to a choice that allows only one property to exist. It is
     * therefore removable from the request, consequently if the value assigned to this
     * property is null, the property is removed from this object
     * @param \Stuba\StructType\AdultElement $adult
     * @return \Stuba\StructType\ArrayOfChoice6
     */
    public function setAdult(\Stuba\StructType\AdultElement $adult = null)
    {
        if (is_null($adult) || (is_array($adult) && empty($adult))) {
            unset($this->Adult);
        } else {
            $this->Adult = $adult;
        }
        return $this;
    }
    /**
     * Get Child value
     * @return \Stuba\StructType\ChildElement
     */
    public function getChild()
    {
        return isset($this->Child) ? $this->Child : null;
    }
    /**
     * Set Child value
     * This property belongs to a choice that allows only one property to exist. It is
     * therefore removable from the request, consequently if the value assigned to this
     * property is null, the property is removed from this object
     * @param \Stuba\StructType\ChildElement $child
     * @return \Stuba\StructType\ArrayOfChoice6
     */
    public function setChild(\Stuba\StructType\ChildElement $child = null)
    {
        if (is_null($child) || (is_array($child) && empty($child))) {
            unset($this->Child);
        } else {
            $this->Child = $child;
        }
        return $this;
    }
}
