<?php

namespace Stuba\ArrayType;

use \WsdlToPhp\PackageBase\AbstractStructArrayBase;

/**
 * This class stands for ArrayOfUpgradeElement ArrayType
 * @subpackage Arrays
 */
class ArrayOfUpgradeElement extends AbstractStructArrayBase
{
    /**
     * The Upgrade
     * Meta information extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * - nillable: true
     * @var \Stuba\StructType\UpgradeElement[]
     */
    public $Upgrade;
    /**
     * Constructor method for ArrayOfUpgradeElement
     * @uses ArrayOfUpgradeElement::setUpgrade()
     * @param \Stuba\StructType\UpgradeElement[] $upgrade
     */
    public function __construct(array $upgrade = array())
    {
        $this
            ->setUpgrade($upgrade);
    }
    /**
     * Get Upgrade value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \Stuba\StructType\UpgradeElement[]|null
     */
    public function getUpgrade()
    {
        return isset($this->Upgrade) ? $this->Upgrade : null;
    }
    /**
     * Set Upgrade value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \Stuba\StructType\UpgradeElement[] $upgrade
     * @return \Stuba\ArrayType\ArrayOfUpgradeElement
     */
    public function setUpgrade(array $upgrade = array())
    {
        if (is_null($upgrade) || (is_array($upgrade) && empty($upgrade))) {
            unset($this->Upgrade);
        } else {
            $this->Upgrade = $upgrade;
        }
        return $this;
    }
    /**
     * Add item to Upgrade value
     * @throws \InvalidArgumentException
     * @param \Stuba\StructType\UpgradeElement $item
     * @return \Stuba\ArrayType\ArrayOfUpgradeElement
     */
    public function addToUpgrade(\Stuba\StructType\UpgradeElement $item)
    {
        $this->Upgrade[] = $item;
        return $this;
    }
    /**
     * Returns the current element
     * @see AbstractStructArrayBase::current()
     * @return \Stuba\StructType\UpgradeElement|null
     */
    public function current()
    {
        return parent::current();
    }
    /**
     * Returns the indexed element
     * @see AbstractStructArrayBase::item()
     * @param int $index
     * @return \Stuba\StructType\UpgradeElement|null
     */
    public function item($index)
    {
        return parent::item($index);
    }
    /**
     * Returns the first element
     * @see AbstractStructArrayBase::first()
     * @return \Stuba\StructType\UpgradeElement|null
     */
    public function first()
    {
        return parent::first();
    }
    /**
     * Returns the last element
     * @see AbstractStructArrayBase::last()
     * @return \Stuba\StructType\UpgradeElement|null
     */
    public function last()
    {
        return parent::last();
    }
    /**
     * Returns the element at the offset
     * @see AbstractStructArrayBase::offsetGet()
     * @param int $offset
     * @return \Stuba\StructType\UpgradeElement|null
     */
    public function offsetGet($offset)
    {
        return parent::offsetGet($offset);
    }
    /**
     * Returns the attribute name
     * @see AbstractStructArrayBase::getAttributeName()
     * @return string Upgrade
     */
    public function getAttributeName()
    {
        return 'Upgrade';
    }
}
