<?php

namespace Stuba\ArrayType;

use \WsdlToPhp\PackageBase\AbstractStructArrayBase;

/**
 * This class stands for ArrayOfPartnerSellingPrice ArrayType
 * @subpackage Arrays
 */
class ArrayOfPartnerSellingPrice extends AbstractStructArrayBase
{
    /**
     * The PartnerSellingPrice
     * Meta information extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * - nillable: true
     * @var \Stuba\StructType\PartnerSellingPrice[]
     */
    public $PartnerSellingPrice;
    /**
     * Constructor method for ArrayOfPartnerSellingPrice
     * @uses ArrayOfPartnerSellingPrice::setPartnerSellingPrice()
     * @param \Stuba\StructType\PartnerSellingPrice[] $partnerSellingPrice
     */
    public function __construct(array $partnerSellingPrice = array())
    {
        $this
            ->setPartnerSellingPrice($partnerSellingPrice);
    }
    /**
     * Get PartnerSellingPrice value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \Stuba\StructType\PartnerSellingPrice[]|null
     */
    public function getPartnerSellingPrice()
    {
        return isset($this->PartnerSellingPrice) ? $this->PartnerSellingPrice : null;
    }
    /**
     * Set PartnerSellingPrice value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \Stuba\StructType\PartnerSellingPrice[] $partnerSellingPrice
     * @return \Stuba\ArrayType\ArrayOfPartnerSellingPrice
     */
    public function setPartnerSellingPrice(array $partnerSellingPrice = array())
    {
        if (is_null($partnerSellingPrice) || (is_array($partnerSellingPrice) && empty($partnerSellingPrice))) {
            unset($this->PartnerSellingPrice);
        } else {
            $this->PartnerSellingPrice = $partnerSellingPrice;
        }
        return $this;
    }
    /**
     * Add item to PartnerSellingPrice value
     * @throws \InvalidArgumentException
     * @param \Stuba\StructType\PartnerSellingPrice $item
     * @return \Stuba\ArrayType\ArrayOfPartnerSellingPrice
     */
    public function addToPartnerSellingPrice(\Stuba\StructType\PartnerSellingPrice $item)
    {
        $this->PartnerSellingPrice[] = $item;
        return $this;
    }
    /**
     * Returns the current element
     * @see AbstractStructArrayBase::current()
     * @return \Stuba\StructType\PartnerSellingPrice|null
     */
    public function current()
    {
        return parent::current();
    }
    /**
     * Returns the indexed element
     * @see AbstractStructArrayBase::item()
     * @param int $index
     * @return \Stuba\StructType\PartnerSellingPrice|null
     */
    public function item($index)
    {
        return parent::item($index);
    }
    /**
     * Returns the first element
     * @see AbstractStructArrayBase::first()
     * @return \Stuba\StructType\PartnerSellingPrice|null
     */
    public function first()
    {
        return parent::first();
    }
    /**
     * Returns the last element
     * @see AbstractStructArrayBase::last()
     * @return \Stuba\StructType\PartnerSellingPrice|null
     */
    public function last()
    {
        return parent::last();
    }
    /**
     * Returns the element at the offset
     * @see AbstractStructArrayBase::offsetGet()
     * @param int $offset
     * @return \Stuba\StructType\PartnerSellingPrice|null
     */
    public function offsetGet($offset)
    {
        return parent::offsetGet($offset);
    }
    /**
     * Returns the attribute name
     * @see AbstractStructArrayBase::getAttributeName()
     * @return string PartnerSellingPrice
     */
    public function getAttributeName()
    {
        return 'PartnerSellingPrice';
    }
}
