<?php

namespace Stuba\StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for ChargeElement StructType
 * @subpackage Structs
 */
class ChargeElement extends AbstractStructBase
{
    /**
     * The Id
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var int
     */
    public $Id;
    /**
     * The CreationDate
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $CreationDate;
    /**
     * The PartnerSellingPriceHierarchy
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \Stuba\ArrayType\ArrayOfPartnerSellingPrice
     */
    public $PartnerSellingPriceHierarchy;
    /**
     * The PriceDetails
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \Stuba\ArrayType\ArrayOfPriceDetailElement
     */
    public $PriceDetails;
    /**
     * The TotalSellingPrice
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \Stuba\StructType\MoneyElement
     */
    public $TotalSellingPrice;
    /**
     * The AssociatedItemId
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var int
     */
    public $AssociatedItemId;
    /**
     * Constructor method for ChargeElement
     * @uses ChargeElement::setId()
     * @uses ChargeElement::setCreationDate()
     * @uses ChargeElement::setPartnerSellingPriceHierarchy()
     * @uses ChargeElement::setPriceDetails()
     * @uses ChargeElement::setTotalSellingPrice()
     * @uses ChargeElement::setAssociatedItemId()
     * @param int $id
     * @param string $creationDate
     * @param \Stuba\ArrayType\ArrayOfPartnerSellingPrice $partnerSellingPriceHierarchy
     * @param \Stuba\ArrayType\ArrayOfPriceDetailElement $priceDetails
     * @param \Stuba\StructType\MoneyElement $totalSellingPrice
     * @param int $associatedItemId
     */
    public function __construct($id = null, $creationDate = null, \Stuba\ArrayType\ArrayOfPartnerSellingPrice $partnerSellingPriceHierarchy = null, \Stuba\ArrayType\ArrayOfPriceDetailElement $priceDetails = null, \Stuba\StructType\MoneyElement $totalSellingPrice = null, $associatedItemId = null)
    {
        $this
            ->setId($id)
            ->setCreationDate($creationDate)
            ->setPartnerSellingPriceHierarchy($partnerSellingPriceHierarchy)
            ->setPriceDetails($priceDetails)
            ->setTotalSellingPrice($totalSellingPrice)
            ->setAssociatedItemId($associatedItemId);
    }
    /**
     * Get Id value
     * @return int|null
     */
    public function getId()
    {
        return $this->Id;
    }
    /**
     * Set Id value
     * @param int $id
     * @return \Stuba\StructType\ChargeElement
     */
    public function setId($id = null)
    {
        $this->Id = $id;
        return $this;
    }
    /**
     * Get CreationDate value
     * @return string|null
     */
    public function getCreationDate()
    {
        return $this->CreationDate;
    }
    /**
     * Set CreationDate value
     * @param string $creationDate
     * @return \Stuba\StructType\ChargeElement
     */
    public function setCreationDate($creationDate = null)
    {
        $this->CreationDate = $creationDate;
        return $this;
    }
    /**
     * Get PartnerSellingPriceHierarchy value
     * @return \Stuba\ArrayType\ArrayOfPartnerSellingPrice|null
     */
    public function getPartnerSellingPriceHierarchy()
    {
        return $this->PartnerSellingPriceHierarchy;
    }
    /**
     * Set PartnerSellingPriceHierarchy value
     * @param \Stuba\ArrayType\ArrayOfPartnerSellingPrice $partnerSellingPriceHierarchy
     * @return \Stuba\StructType\ChargeElement
     */
    public function setPartnerSellingPriceHierarchy(\Stuba\ArrayType\ArrayOfPartnerSellingPrice $partnerSellingPriceHierarchy = null)
    {
        $this->PartnerSellingPriceHierarchy = $partnerSellingPriceHierarchy;
        return $this;
    }
    /**
     * Get PriceDetails value
     * @return \Stuba\ArrayType\ArrayOfPriceDetailElement|null
     */
    public function getPriceDetails()
    {
        return $this->PriceDetails;
    }
    /**
     * Set PriceDetails value
     * @param \Stuba\ArrayType\ArrayOfPriceDetailElement $priceDetails
     * @return \Stuba\StructType\ChargeElement
     */
    public function setPriceDetails(\Stuba\ArrayType\ArrayOfPriceDetailElement $priceDetails = null)
    {
        $this->PriceDetails = $priceDetails;
        return $this;
    }
    /**
     * Get TotalSellingPrice value
     * @return \Stuba\StructType\MoneyElement|null
     */
    public function getTotalSellingPrice()
    {
        return $this->TotalSellingPrice;
    }
    /**
     * Set TotalSellingPrice value
     * @param \Stuba\StructType\MoneyElement $totalSellingPrice
     * @return \Stuba\StructType\ChargeElement
     */
    public function setTotalSellingPrice(\Stuba\StructType\MoneyElement $totalSellingPrice = null)
    {
        $this->TotalSellingPrice = $totalSellingPrice;
        return $this;
    }
    /**
     * Get AssociatedItemId value
     * @return int|null
     */
    public function getAssociatedItemId()
    {
        return $this->AssociatedItemId;
    }
    /**
     * Set AssociatedItemId value
     * @param int $associatedItemId
     * @return \Stuba\StructType\ChargeElement
     */
    public function setAssociatedItemId($associatedItemId = null)
    {
        $this->AssociatedItemId = $associatedItemId;
        return $this;
    }
}
