<?php

namespace Stuba\EnumType;

use \WsdlToPhp\PackageBase\AbstractStructEnumBase;

/**
 * This class stands for EnumDetailLevel EnumType
 * @subpackage Enumerations
 */
class EnumDetailLevel extends AbstractStructEnumBase
{
    /**
     * Constant for value 'basic'
     * @return string 'basic'
     */
    const VALUE_BASIC = 'basic';
    /**
     * Constant for value 'summary'
     * @return string 'summary'
     */
    const VALUE_SUMMARY = 'summary';
    /**
     * Constant for value 'full'
     * @return string 'full'
     */
    const VALUE_FULL = 'full';
    /**
     * Constant for value 'custom'
     * @return string 'custom'
     */
    const VALUE_CUSTOM = 'custom';
    /**
     * Return allowed values
     * @uses self::VALUE_BASIC
     * @uses self::VALUE_SUMMARY
     * @uses self::VALUE_FULL
     * @uses self::VALUE_CUSTOM
     * @return string[]
     */
    public static function getValidValues()
    {
        return array(
            self::VALUE_BASIC,
            self::VALUE_SUMMARY,
            self::VALUE_FULL,
            self::VALUE_CUSTOM,
        );
    }
}
