<?php

namespace Stuba\ArrayType;

use \WsdlToPhp\PackageBase\AbstractStructArrayBase;

/**
 * This class stands for ArrayOfExtraElement1 ArrayType
 * @subpackage Arrays
 */
class ArrayOfExtraElement1 extends AbstractStructArrayBase
{
    /**
     * The ExtraElement
     * Meta information extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * - nillable: true
     * @var \Stuba\StructType\ExtraElement[]
     */
    public $ExtraElement;
    /**
     * Constructor method for ArrayOfExtraElement1
     * @uses ArrayOfExtraElement1::setExtraElement()
     * @param \Stuba\StructType\ExtraElement[] $extraElement
     */
    public function __construct(array $extraElement = array())
    {
        $this
            ->setExtraElement($extraElement);
    }
    /**
     * Get ExtraElement value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \Stuba\StructType\ExtraElement[]|null
     */
    public function getExtraElement()
    {
        return isset($this->ExtraElement) ? $this->ExtraElement : null;
    }
    /**
     * Set ExtraElement value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \Stuba\StructType\ExtraElement[] $extraElement
     * @return \Stuba\ArrayType\ArrayOfExtraElement1
     */
    public function setExtraElement(array $extraElement = array())
    {
        if (is_null($extraElement) || (is_array($extraElement) && empty($extraElement))) {
            unset($this->ExtraElement);
        } else {
            $this->ExtraElement = $extraElement;
        }
        return $this;
    }
    /**
     * Add item to ExtraElement value
     * @throws \InvalidArgumentException
     * @param \Stuba\StructType\ExtraElement $item
     * @return \Stuba\ArrayType\ArrayOfExtraElement1
     */
    public function addToExtraElement(\Stuba\StructType\ExtraElement $item)
    {
        $this->ExtraElement[] = $item;
        return $this;
    }
    /**
     * Returns the current element
     * @see AbstractStructArrayBase::current()
     * @return \Stuba\StructType\ExtraElement|null
     */
    public function current()
    {
        return parent::current();
    }
    /**
     * Returns the indexed element
     * @see AbstractStructArrayBase::item()
     * @param int $index
     * @return \Stuba\StructType\ExtraElement|null
     */
    public function item($index)
    {
        return parent::item($index);
    }
    /**
     * Returns the first element
     * @see AbstractStructArrayBase::first()
     * @return \Stuba\StructType\ExtraElement|null
     */
    public function first()
    {
        return parent::first();
    }
    /**
     * Returns the last element
     * @see AbstractStructArrayBase::last()
     * @return \Stuba\StructType\ExtraElement|null
     */
    public function last()
    {
        return parent::last();
    }
    /**
     * Returns the element at the offset
     * @see AbstractStructArrayBase::offsetGet()
     * @param int $offset
     * @return \Stuba\StructType\ExtraElement|null
     */
    public function offsetGet($offset)
    {
        return parent::offsetGet($offset);
    }
    /**
     * Returns the attribute name
     * @see AbstractStructArrayBase::getAttributeName()
     * @return string ExtraElement
     */
    public function getAttributeName()
    {
        return 'ExtraElement';
    }
}
