<?php

namespace Stuba\ArrayType;

use \WsdlToPhp\PackageBase\AbstractStructArrayBase;

/**
 * This class stands for ArrayOfExtraElement ArrayType
 * @subpackage Arrays
 */
class ArrayOfExtraElement extends AbstractStructArrayBase
{
    /**
     * The Extra
     * Meta information extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * - nillable: true
     * @var \Stuba\StructType\ExtraElement[]
     */
    public $Extra;
    /**
     * Constructor method for ArrayOfExtraElement
     * @uses ArrayOfExtraElement::setExtra()
     * @param \Stuba\StructType\ExtraElement[] $extra
     */
    public function __construct(array $extra = array())
    {
        $this
            ->setExtra($extra);
    }
    /**
     * Get Extra value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \Stuba\StructType\ExtraElement[]|null
     */
    public function getExtra()
    {
        return isset($this->Extra) ? $this->Extra : null;
    }
    /**
     * Set Extra value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \Stuba\StructType\ExtraElement[] $extra
     * @return \Stuba\ArrayType\ArrayOfExtraElement
     */
    public function setExtra(array $extra = array())
    {
        if (is_null($extra) || (is_array($extra) && empty($extra))) {
            unset($this->Extra);
        } else {
            $this->Extra = $extra;
        }
        return $this;
    }
    /**
     * Add item to Extra value
     * @throws \InvalidArgumentException
     * @param \Stuba\StructType\ExtraElement $item
     * @return \Stuba\ArrayType\ArrayOfExtraElement
     */
    public function addToExtra(\Stuba\StructType\ExtraElement $item)
    {
        $this->Extra[] = $item;
        return $this;
    }
    /**
     * Returns the current element
     * @see AbstractStructArrayBase::current()
     * @return \Stuba\StructType\ExtraElement|null
     */
    public function current()
    {
        return parent::current();
    }
    /**
     * Returns the indexed element
     * @see AbstractStructArrayBase::item()
     * @param int $index
     * @return \Stuba\StructType\ExtraElement|null
     */
    public function item($index)
    {
        return parent::item($index);
    }
    /**
     * Returns the first element
     * @see AbstractStructArrayBase::first()
     * @return \Stuba\StructType\ExtraElement|null
     */
    public function first()
    {
        return parent::first();
    }
    /**
     * Returns the last element
     * @see AbstractStructArrayBase::last()
     * @return \Stuba\StructType\ExtraElement|null
     */
    public function last()
    {
        return parent::last();
    }
    /**
     * Returns the element at the offset
     * @see AbstractStructArrayBase::offsetGet()
     * @param int $offset
     * @return \Stuba\StructType\ExtraElement|null
     */
    public function offsetGet($offset)
    {
        return parent::offsetGet($offset);
    }
    /**
     * Returns the attribute name
     * @see AbstractStructArrayBase::getAttributeName()
     * @return string Extra
     */
    public function getAttributeName()
    {
        return 'Extra';
    }
}
