<?php

namespace Stuba\StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for TransferSupplierInfo StructType
 * @subpackage Structs
 */
class TransferSupplierInfo extends AbstractStructBase
{
    /**
     * The Supplier
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $Supplier;
    /**
     * The PickupPointCode
     * Meta information extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * @var \Stuba\StructType\TransferSupplierCode[]
     */
    public $PickupPointCode;
    /**
     * The DestinationPointCode
     * Meta information extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * @var \Stuba\StructType\TransferSupplierCode[]
     */
    public $DestinationPointCode;
    /**
     * The RouteCode
     * Meta information extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * @var \Stuba\StructType\TransferSupplierCode[]
     */
    public $RouteCode;
    /**
     * The BookingRef
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $BookingRef;
    /**
     * The ItemRef
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $ItemRef;
    /**
     * Constructor method for TransferSupplierInfo
     * @uses TransferSupplierInfo::setSupplier()
     * @uses TransferSupplierInfo::setPickupPointCode()
     * @uses TransferSupplierInfo::setDestinationPointCode()
     * @uses TransferSupplierInfo::setRouteCode()
     * @uses TransferSupplierInfo::setBookingRef()
     * @uses TransferSupplierInfo::setItemRef()
     * @param string $supplier
     * @param \Stuba\StructType\TransferSupplierCode[] $pickupPointCode
     * @param \Stuba\StructType\TransferSupplierCode[] $destinationPointCode
     * @param \Stuba\StructType\TransferSupplierCode[] $routeCode
     * @param string $bookingRef
     * @param string $itemRef
     */
    public function __construct($supplier = null, array $pickupPointCode = array(), array $destinationPointCode = array(), array $routeCode = array(), $bookingRef = null, $itemRef = null)
    {
        $this
            ->setSupplier($supplier)
            ->setPickupPointCode($pickupPointCode)
            ->setDestinationPointCode($destinationPointCode)
            ->setRouteCode($routeCode)
            ->setBookingRef($bookingRef)
            ->setItemRef($itemRef);
    }
    /**
     * Get Supplier value
     * @return string|null
     */
    public function getSupplier()
    {
        return $this->Supplier;
    }
    /**
     * Set Supplier value
     * @param string $supplier
     * @return \Stuba\StructType\TransferSupplierInfo
     */
    public function setSupplier($supplier = null)
    {
        $this->Supplier = $supplier;
        return $this;
    }
    /**
     * Get PickupPointCode value
     * @return \Stuba\StructType\TransferSupplierCode[]|null
     */
    public function getPickupPointCode()
    {
        return $this->PickupPointCode;
    }
    /**
     * Set PickupPointCode value
     * @param \Stuba\StructType\TransferSupplierCode[] $pickupPointCode
     * @return \Stuba\StructType\TransferSupplierInfo
     */
    public function setPickupPointCode(array $pickupPointCode = array())
    {
        $this->PickupPointCode = $pickupPointCode;
        return $this;
    }
    /**
     * Add item to PickupPointCode value
     * @throws \InvalidArgumentException
     * @param \Stuba\StructType\TransferSupplierCode $item
     * @return \Stuba\StructType\TransferSupplierInfo
     */
    public function addToPickupPointCode(\Stuba\StructType\TransferSupplierCode $item)
    {
        $this->PickupPointCode[] = $item;
        return $this;
    }
    /**
     * Get DestinationPointCode value
     * @return \Stuba\StructType\TransferSupplierCode[]|null
     */
    public function getDestinationPointCode()
    {
        return $this->DestinationPointCode;
    }
    /**
     * Set DestinationPointCode value
     * @param \Stuba\StructType\TransferSupplierCode[] $destinationPointCode
     * @return \Stuba\StructType\TransferSupplierInfo
     */
    public function setDestinationPointCode(array $destinationPointCode = array())
    {
        $this->DestinationPointCode = $destinationPointCode;
        return $this;
    }
    /**
     * Add item to DestinationPointCode value
     * @throws \InvalidArgumentException
     * @param \Stuba\StructType\TransferSupplierCode $item
     * @return \Stuba\StructType\TransferSupplierInfo
     */
    public function addToDestinationPointCode(\Stuba\StructType\TransferSupplierCode $item)
    {
        $this->DestinationPointCode[] = $item;
        return $this;
    }
    /**
     * Get RouteCode value
     * @return \Stuba\StructType\TransferSupplierCode[]|null
     */
    public function getRouteCode()
    {
        return $this->RouteCode;
    }
    /**
     * Set RouteCode value
     * @param \Stuba\StructType\TransferSupplierCode[] $routeCode
     * @return \Stuba\StructType\TransferSupplierInfo
     */
    public function setRouteCode(array $routeCode = array())
    {
        $this->RouteCode = $routeCode;
        return $this;
    }
    /**
     * Add item to RouteCode value
     * @throws \InvalidArgumentException
     * @param \Stuba\StructType\TransferSupplierCode $item
     * @return \Stuba\StructType\TransferSupplierInfo
     */
    public function addToRouteCode(\Stuba\StructType\TransferSupplierCode $item)
    {
        $this->RouteCode[] = $item;
        return $this;
    }
    /**
     * Get BookingRef value
     * @return string|null
     */
    public function getBookingRef()
    {
        return $this->BookingRef;
    }
    /**
     * Set BookingRef value
     * @param string $bookingRef
     * @return \Stuba\StructType\TransferSupplierInfo
     */
    public function setBookingRef($bookingRef = null)
    {
        $this->BookingRef = $bookingRef;
        return $this;
    }
    /**
     * Get ItemRef value
     * @return string|null
     */
    public function getItemRef()
    {
        return $this->ItemRef;
    }
    /**
     * Set ItemRef value
     * @param string $itemRef
     * @return \Stuba\StructType\TransferSupplierInfo
     */
    public function setItemRef($itemRef = null)
    {
        $this->ItemRef = $itemRef;
        return $this;
    }
}
