<?php

namespace Stuba\StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for TransferAvailablitySearchResult StructType
 * @subpackage Structs
 */
class TransferAvailablitySearchResult extends ResponseBase
{
    /**
     * The TransferAvailability
     * Meta information extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * @var \Stuba\StructType\TransferAvailabilityElement[]
     */
    public $TransferAvailability;
    /**
     * The SupplierErrors
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \Stuba\StructType\SupplierErrorsElement
     */
    public $SupplierErrors;
    /**
     * The DebugInfo
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \Stuba\StructType\DebugInfoElement
     */
    public $DebugInfo;
    /**
     * Constructor method for TransferAvailablitySearchResult
     * @uses TransferAvailablitySearchResult::setTransferAvailability()
     * @uses TransferAvailablitySearchResult::setSupplierErrors()
     * @uses TransferAvailablitySearchResult::setDebugInfo()
     * @param \Stuba\StructType\TransferAvailabilityElement[] $transferAvailability
     * @param \Stuba\StructType\SupplierErrorsElement $supplierErrors
     * @param \Stuba\StructType\DebugInfoElement $debugInfo
     */
    public function __construct(array $transferAvailability = array(), \Stuba\StructType\SupplierErrorsElement $supplierErrors = null, \Stuba\StructType\DebugInfoElement $debugInfo = null)
    {
        $this
            ->setTransferAvailability($transferAvailability)
            ->setSupplierErrors($supplierErrors)
            ->setDebugInfo($debugInfo);
    }
    /**
     * Get TransferAvailability value
     * @return \Stuba\StructType\TransferAvailabilityElement[]|null
     */
    public function getTransferAvailability()
    {
        return $this->TransferAvailability;
    }
    /**
     * Set TransferAvailability value
     * @param \Stuba\StructType\TransferAvailabilityElement[] $transferAvailability
     * @return \Stuba\StructType\TransferAvailablitySearchResult
     */
    public function setTransferAvailability(array $transferAvailability = array())
    {
        $this->TransferAvailability = $transferAvailability;
        return $this;
    }
    /**
     * Add item to TransferAvailability value
     * @throws \InvalidArgumentException
     * @param \Stuba\StructType\TransferAvailabilityElement $item
     * @return \Stuba\StructType\TransferAvailablitySearchResult
     */
    public function addToTransferAvailability(\Stuba\StructType\TransferAvailabilityElement $item)
    {
        $this->TransferAvailability[] = $item;
        return $this;
    }
    /**
     * Get SupplierErrors value
     * @return \Stuba\StructType\SupplierErrorsElement|null
     */
    public function getSupplierErrors()
    {
        return $this->SupplierErrors;
    }
    /**
     * Set SupplierErrors value
     * @param \Stuba\StructType\SupplierErrorsElement $supplierErrors
     * @return \Stuba\StructType\TransferAvailablitySearchResult
     */
    public function setSupplierErrors(\Stuba\StructType\SupplierErrorsElement $supplierErrors = null)
    {
        $this->SupplierErrors = $supplierErrors;
        return $this;
    }
    /**
     * Get DebugInfo value
     * @return \Stuba\StructType\DebugInfoElement|null
     */
    public function getDebugInfo()
    {
        return $this->DebugInfo;
    }
    /**
     * Set DebugInfo value
     * @param \Stuba\StructType\DebugInfoElement $debugInfo
     * @return \Stuba\StructType\TransferAvailablitySearchResult
     */
    public function setDebugInfo(\Stuba\StructType\DebugInfoElement $debugInfo = null)
    {
        $this->DebugInfo = $debugInfo;
        return $this;
    }
}
