<?php

namespace Stuba\StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for MessageElement StructType
 * @subpackage Structs
 */
class MessageElement extends AbstractStructBase
{
    /**
     * The Type
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $Type;
    /**
     * The Text
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $Text;
    /**
     * Constructor method for MessageElement
     * @uses MessageElement::setType()
     * @uses MessageElement::setText()
     * @param string $type
     * @param string $text
     */
    public function __construct($type = null, $text = null)
    {
        $this
            ->setType($type)
            ->setText($text);
    }
    /**
     * Get Type value
     * @return string|null
     */
    public function getType()
    {
        return $this->Type;
    }
    /**
     * Set Type value
     * @param string $type
     * @return \Stuba\StructType\MessageElement
     */
    public function setType($type = null)
    {
        $this->Type = $type;
        return $this;
    }
    /**
     * Get Text value
     * @return string|null
     */
    public function getText()
    {
        return $this->Text;
    }
    /**
     * Set Text value
     * @param string $text
     * @return \Stuba\StructType\MessageElement
     */
    public function setText($text = null)
    {
        $this->Text = $text;
        return $this;
    }
}
