<?php

namespace Stuba\StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for HotelSearch StructType
 * @subpackage Structs
 */
class HotelSearch extends AbstractStructBase
{
    /**
     * The DetailLevel
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var string
     */
    public $DetailLevel;
    /**
     * The xiRequest
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \Stuba\StructType\HotelSearch
     */
    public $xiRequest;
    /**
     * The Authority
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \Stuba\StructType\AuthorityElement
     */
    public $Authority;
    /**
     * The RegionId
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var int
     */
    public $RegionId;
    /**
     * The HotelId
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var int
     */
    public $HotelId;
    /**
     * The HotelSearchCriteria
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \Stuba\StructType\HotelSearchCriteriaElement
     */
    public $HotelSearchCriteria;
    /**
     * The CustomDetailLevel
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $CustomDetailLevel;
    /**
     * Constructor method for HotelSearch
     * @uses HotelSearch::setDetailLevel()
     * @uses HotelSearch::setXiRequest()
     * @uses HotelSearch::setAuthority()
     * @uses HotelSearch::setRegionId()
     * @uses HotelSearch::setHotelId()
     * @uses HotelSearch::setHotelSearchCriteria()
     * @uses HotelSearch::setCustomDetailLevel()
     * @param string $detailLevel
     * @param \Stuba\StructType\HotelSearch $xiRequest
     * @param \Stuba\StructType\AuthorityElement $authority
     * @param int $regionId
     * @param int $hotelId
     * @param \Stuba\StructType\HotelSearchCriteriaElement $hotelSearchCriteria
     * @param string $customDetailLevel
     */
    public function __construct($detailLevel = null, \Stuba\StructType\HotelSearch $xiRequest = null, \Stuba\StructType\AuthorityElement $authority = null, $regionId = null, $hotelId = null, \Stuba\StructType\HotelSearchCriteriaElement $hotelSearchCriteria = null, $customDetailLevel = null)
    {
        $this
            ->setDetailLevel($detailLevel)
            ->setXiRequest($xiRequest)
            ->setAuthority($authority)
            ->setRegionId($regionId)
            ->setHotelId($hotelId)
            ->setHotelSearchCriteria($hotelSearchCriteria)
            ->setCustomDetailLevel($customDetailLevel);
    }
    /**
     * Get DetailLevel value
     * @return string
     */
    public function getDetailLevel()
    {
        return $this->DetailLevel;
    }
    /**
     * Set DetailLevel value
     * @param string $detailLevel
     * @return \Stuba\StructType\HotelSearch
     */
    public function setDetailLevel($detailLevel = null)
    {
        $this->DetailLevel = $detailLevel;
        return $this;
    }
    /**
     * Get xiRequest value
     * @return \Stuba\StructType\HotelSearch|null
     */
    public function getXiRequest()
    {
        return $this->xiRequest;
    }
    /**
     * Set xiRequest value
     * @param \Stuba\StructType\HotelSearch $xiRequest
     * @return \Stuba\StructType\HotelSearch
     */
    public function setXiRequest(\Stuba\StructType\HotelSearch $xiRequest = null)
    {
        $this->xiRequest = $xiRequest;
        return $this;
    }
    /**
     * Get Authority value
     * @return \Stuba\StructType\AuthorityElement|null
     */
    public function getAuthority()
    {
        return $this->Authority;
    }
    /**
     * Set Authority value
     * @param \Stuba\StructType\AuthorityElement $authority
     * @return \Stuba\StructType\HotelSearch
     */
    public function setAuthority(\Stuba\StructType\AuthorityElement $authority = null)
    {
        $this->Authority = $authority;
        return $this;
    }
    /**
     * Get RegionId value
     * @return int|null
     */
    public function getRegionId()
    {
        return $this->RegionId;
    }
    /**
     * Set RegionId value
     * @param int $regionId
     * @return \Stuba\StructType\HotelSearch
     */
    public function setRegionId($regionId = null)
    {
        $this->RegionId = $regionId;
        return $this;
    }
    /**
     * Get HotelId value
     * @return int|null
     */
    public function getHotelId()
    {
        return $this->HotelId;
    }
    /**
     * Set HotelId value
     * @param int $hotelId
     * @return \Stuba\StructType\HotelSearch
     */
    public function setHotelId($hotelId = null)
    {
        $this->HotelId = $hotelId;
        return $this;
    }
    /**
     * Get HotelSearchCriteria value
     * @return \Stuba\StructType\HotelSearchCriteriaElement|null
     */
    public function getHotelSearchCriteria()
    {
        return $this->HotelSearchCriteria;
    }
    /**
     * Set HotelSearchCriteria value
     * @param \Stuba\StructType\HotelSearchCriteriaElement $hotelSearchCriteria
     * @return \Stuba\StructType\HotelSearch
     */
    public function setHotelSearchCriteria(\Stuba\StructType\HotelSearchCriteriaElement $hotelSearchCriteria = null)
    {
        $this->HotelSearchCriteria = $hotelSearchCriteria;
        return $this;
    }
    /**
     * Get CustomDetailLevel value
     * @return string|null
     */
    public function getCustomDetailLevel()
    {
        return $this->CustomDetailLevel;
    }
    /**
     * Set CustomDetailLevel value
     * @param string $customDetailLevel
     * @return \Stuba\StructType\HotelSearch
     */
    public function setCustomDetailLevel($customDetailLevel = null)
    {
        $this->CustomDetailLevel = $customDetailLevel;
        return $this;
    }
}
