<?php

namespace Stuba\StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for HotelElement StructType
 * @subpackage Structs
 */
class HotelElement extends AbstractStructBase
{
    /**
     * The Id
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var int
     */
    public $Id;
    /**
     * The Name
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $Name;
    /**
     * The Region
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \Stuba\StructType\HotelRegionElement
     */
    public $Region;
    /**
     * The Type
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $Type;
    /**
     * The Address
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \Stuba\StructType\AddressElement
     */
    public $Address;
    /**
     * The Stars
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var int
     */
    public $Stars;
    /**
     * The MinRate
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var float
     */
    public $MinRate;
    /**
     * The MaxRate
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var float
     */
    public $MaxRate;
    /**
     * The GeneralInfo
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \Stuba\StructType\GeneralInfoElement
     */
    public $GeneralInfo;
    /**
     * The Photo
     * Meta information extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * @var \Stuba\StructType\PhotoElement[]
     */
    public $Photo;
    /**
     * The Description
     * Meta information extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * @var \Stuba\StructType\DescriptionElement[]
     */
    public $Description;
    /**
     * The Amenity
     * Meta information extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * @var \Stuba\StructType\AmenityElement[]
     */
    public $Amenity;
    /**
     * The SupplierInfo
     * Meta information extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * @var \Stuba\StructType\HotelSupplierInfoElement[]
     */
    public $SupplierInfo;
    /**
     * The AdditionalProperties
     * Meta information extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * @var \Stuba\StructType\EntityPropertyElement[]
     */
    public $AdditionalProperties;
    /**
     * The Rating
     * Meta information extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * @var \Stuba\StructType\RatingElement[]
     */
    public $Rating;
    /**
     * The Rank
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var int
     */
    public $Rank;
    /**
     * The id
     * @var int
     */
    public $id;
    /**
     * The name
     * @var string
     */
    public $name;
    /**
     * The type
     * @var string
     */
    public $type;
    /**
     * The stars
     * @var int
     */
    public $stars;
    /**
     * The minRate
     * @var float
     */
    public $minRate;
    /**
     * The maxRate
     * @var float
     */
    public $maxRate;
    /**
     * The rank
     * @var int
     */
    public $rank;
    /**
     * Constructor method for HotelElement
     * @uses HotelElement::setId()
     * @uses HotelElement::setName()
     * @uses HotelElement::setRegion()
     * @uses HotelElement::setType()
     * @uses HotelElement::setAddress()
     * @uses HotelElement::setStars()
     * @uses HotelElement::setMinRate()
     * @uses HotelElement::setMaxRate()
     * @uses HotelElement::setGeneralInfo()
     * @uses HotelElement::setPhoto()
     * @uses HotelElement::setDescription()
     * @uses HotelElement::setAmenity()
     * @uses HotelElement::setSupplierInfo()
     * @uses HotelElement::setAdditionalProperties()
     * @uses HotelElement::setRating()
     * @uses HotelElement::setRank()
     * @uses HotelElement::setId_1()
     * @uses HotelElement::setName_1()
     * @uses HotelElement::setType_1()
     * @uses HotelElement::setStars_1()
     * @uses HotelElement::setMinRate_1()
     * @uses HotelElement::setMaxRate_1()
     * @uses HotelElement::setRank_1()
     * @param int $id
     * @param string $name
     * @param \Stuba\StructType\HotelRegionElement $region
     * @param string $type
     * @param \Stuba\StructType\AddressElement $address
     * @param int $stars
     * @param float $minRate
     * @param float $maxRate
     * @param \Stuba\StructType\GeneralInfoElement $generalInfo
     * @param \Stuba\StructType\PhotoElement[] $photo
     * @param \Stuba\StructType\DescriptionElement[] $description
     * @param \Stuba\StructType\AmenityElement[] $amenity
     * @param \Stuba\StructType\HotelSupplierInfoElement[] $supplierInfo
     * @param \Stuba\StructType\EntityPropertyElement[] $additionalProperties
     * @param \Stuba\StructType\RatingElement[] $rating
     * @param int $rank
     * @param int $id
     * @param string $name
     * @param string $type
     * @param int $stars
     * @param float $minRate
     * @param float $maxRate
     * @param int $rank
     */
    public function __construct($id = null, $name = null, \Stuba\StructType\HotelRegionElement $region = null, $type = null, \Stuba\StructType\AddressElement $address = null, $stars = null, $minRate = null, $maxRate = null, \Stuba\StructType\GeneralInfoElement $generalInfo = null, array $photo = array(), array $description = array(), array $amenity = array(), array $supplierInfo = array(), array $additionalProperties = array(), array $rating = array(), $rank = null, $id_1 = null, $name_1 = null, $type_1 = null, $stars_1 = null, $minRate_1 = null, $maxRate_1 = null, $rank_1 = null)
    {
        $this
            ->setId($id)
            ->setName($name)
            ->setRegion($region)
            ->setType($type)
            ->setAddress($address)
            ->setStars($stars)
            ->setMinRate($minRate)
            ->setMaxRate($maxRate)
            ->setGeneralInfo($generalInfo)
            ->setPhoto($photo)
            ->setDescription($description)
            ->setAmenity($amenity)
            ->setSupplierInfo($supplierInfo)
            ->setAdditionalProperties($additionalProperties)
            ->setRating($rating)
            ->setRank($rank)
            ->setId_1($id_1)
            ->setName_1($name_1)
            ->setType_1($type_1)
            ->setStars_1($stars_1)
            ->setMinRate_1($minRate_1)
            ->setMaxRate_1($maxRate_1)
            ->setRank_1($rank_1);
    }
    /**
     * Get Id value
     * @return int|null
     */
    public function getId()
    {
        return $this->Id;
    }
    /**
     * Set Id value
     * @param int $id
     * @return \Stuba\StructType\HotelElement
     */
    public function setId($id = null)
    {
        $this->Id = $id;
        return $this;
    }
    /**
     * Get Name value
     * @return string|null
     */
    public function getName()
    {
        return $this->Name;
    }
    /**
     * Set Name value
     * @param string $name
     * @return \Stuba\StructType\HotelElement
     */
    public function setName($name = null)
    {
        $this->Name = $name;
        return $this;
    }
    /**
     * Get Region value
     * @return \Stuba\StructType\HotelRegionElement|null
     */
    public function getRegion()
    {
        return $this->Region;
    }
    /**
     * Set Region value
     * @param \Stuba\StructType\HotelRegionElement $region
     * @return \Stuba\StructType\HotelElement
     */
    public function setRegion(\Stuba\StructType\HotelRegionElement $region = null)
    {
        $this->Region = $region;
        return $this;
    }
    /**
     * Get Type value
     * @return string|null
     */
    public function getType()
    {
        return $this->Type;
    }
    /**
     * Set Type value
     * @param string $type
     * @return \Stuba\StructType\HotelElement
     */
    public function setType($type = null)
    {
        $this->Type = $type;
        return $this;
    }
    /**
     * Get Address value
     * @return \Stuba\StructType\AddressElement|null
     */
    public function getAddress()
    {
        return $this->Address;
    }
    /**
     * Set Address value
     * @param \Stuba\StructType\AddressElement $address
     * @return \Stuba\StructType\HotelElement
     */
    public function setAddress(\Stuba\StructType\AddressElement $address = null)
    {
        $this->Address = $address;
        return $this;
    }
    /**
     * Get Stars value
     * @return int|null
     */
    public function getStars()
    {
        return $this->Stars;
    }
    /**
     * Set Stars value
     * @param int $stars
     * @return \Stuba\StructType\HotelElement
     */
    public function setStars($stars = null)
    {
        $this->Stars = $stars;
        return $this;
    }
    /**
     * Get MinRate value
     * @return float|null
     */
    public function getMinRate()
    {
        return $this->MinRate;
    }
    /**
     * Set MinRate value
     * @param float $minRate
     * @return \Stuba\StructType\HotelElement
     */
    public function setMinRate($minRate = null)
    {
        $this->MinRate = $minRate;
        return $this;
    }
    /**
     * Get MaxRate value
     * @return float|null
     */
    public function getMaxRate()
    {
        return $this->MaxRate;
    }
    /**
     * Set MaxRate value
     * @param float $maxRate
     * @return \Stuba\StructType\HotelElement
     */
    public function setMaxRate($maxRate = null)
    {
        $this->MaxRate = $maxRate;
        return $this;
    }
    /**
     * Get GeneralInfo value
     * @return \Stuba\StructType\GeneralInfoElement|null
     */
    public function getGeneralInfo()
    {
        return $this->GeneralInfo;
    }
    /**
     * Set GeneralInfo value
     * @param \Stuba\StructType\GeneralInfoElement $generalInfo
     * @return \Stuba\StructType\HotelElement
     */
    public function setGeneralInfo(\Stuba\StructType\GeneralInfoElement $generalInfo = null)
    {
        $this->GeneralInfo = $generalInfo;
        return $this;
    }
    /**
     * Get Photo value
     * @return \Stuba\StructType\PhotoElement[]|null
     */
    public function getPhoto()
    {
        return $this->Photo;
    }
    /**
     * Set Photo value
     * @param \Stuba\StructType\PhotoElement[] $photo
     * @return \Stuba\StructType\HotelElement
     */
    public function setPhoto(array $photo = array())
    {
        $this->Photo = $photo;
        return $this;
    }
    /**
     * Add item to Photo value
     * @throws \InvalidArgumentException
     * @param \Stuba\StructType\PhotoElement $item
     * @return \Stuba\StructType\HotelElement
     */
    public function addToPhoto(\Stuba\StructType\PhotoElement $item)
    {
        $this->Photo[] = $item;
        return $this;
    }
    /**
     * Get Description value
     * @return \Stuba\StructType\DescriptionElement[]|null
     */
    public function getDescription()
    {
        return $this->Description;
    }
    /**
     * Set Description value
     * @param \Stuba\StructType\DescriptionElement[] $description
     * @return \Stuba\StructType\HotelElement
     */
    public function setDescription(array $description = array())
    {
        $this->Description = $description;
        return $this;
    }
    /**
     * Add item to Description value
     * @throws \InvalidArgumentException
     * @param \Stuba\StructType\DescriptionElement $item
     * @return \Stuba\StructType\HotelElement
     */
    public function addToDescription(\Stuba\StructType\DescriptionElement $item)
    {
        $this->Description[] = $item;
        return $this;
    }
    /**
     * Get Amenity value
     * @return \Stuba\StructType\AmenityElement[]|null
     */
    public function getAmenity()
    {
        return $this->Amenity;
    }
    /**
     * Set Amenity value
     * @param \Stuba\StructType\AmenityElement[] $amenity
     * @return \Stuba\StructType\HotelElement
     */
    public function setAmenity(array $amenity = array())
    {
        $this->Amenity = $amenity;
        return $this;
    }
    /**
     * Add item to Amenity value
     * @throws \InvalidArgumentException
     * @param \Stuba\StructType\AmenityElement $item
     * @return \Stuba\StructType\HotelElement
     */
    public function addToAmenity(\Stuba\StructType\AmenityElement $item)
    {
        $this->Amenity[] = $item;
        return $this;
    }
    /**
     * Get SupplierInfo value
     * @return \Stuba\StructType\HotelSupplierInfoElement[]|null
     */
    public function getSupplierInfo()
    {
        return $this->SupplierInfo;
    }
    /**
     * Set SupplierInfo value
     * @param \Stuba\StructType\HotelSupplierInfoElement[] $supplierInfo
     * @return \Stuba\StructType\HotelElement
     */
    public function setSupplierInfo(array $supplierInfo = array())
    {
        $this->SupplierInfo = $supplierInfo;
        return $this;
    }
    /**
     * Add item to SupplierInfo value
     * @throws \InvalidArgumentException
     * @param \Stuba\StructType\HotelSupplierInfoElement $item
     * @return \Stuba\StructType\HotelElement
     */
    public function addToSupplierInfo(\Stuba\StructType\HotelSupplierInfoElement $item)
    {
        $this->SupplierInfo[] = $item;
        return $this;
    }
    /**
     * Get AdditionalProperties value
     * @return \Stuba\StructType\EntityPropertyElement[]|null
     */
    public function getAdditionalProperties()
    {
        return $this->AdditionalProperties;
    }
    /**
     * Set AdditionalProperties value
     * @param \Stuba\StructType\EntityPropertyElement[] $additionalProperties
     * @return \Stuba\StructType\HotelElement
     */
    public function setAdditionalProperties(array $additionalProperties = array())
    {
        $this->AdditionalProperties = $additionalProperties;
        return $this;
    }
    /**
     * Add item to AdditionalProperties value
     * @throws \InvalidArgumentException
     * @param \Stuba\StructType\EntityPropertyElement $item
     * @return \Stuba\StructType\HotelElement
     */
    public function addToAdditionalProperties(\Stuba\StructType\EntityPropertyElement $item)
    {
        $this->AdditionalProperties[] = $item;
        return $this;
    }
    /**
     * Get Rating value
     * @return \Stuba\StructType\RatingElement[]|null
     */
    public function getRating()
    {
        return $this->Rating;
    }
    /**
     * Set Rating value
     * @param \Stuba\StructType\RatingElement[] $rating
     * @return \Stuba\StructType\HotelElement
     */
    public function setRating(array $rating = array())
    {
        $this->Rating = $rating;
        return $this;
    }
    /**
     * Add item to Rating value
     * @throws \InvalidArgumentException
     * @param \Stuba\StructType\RatingElement $item
     * @return \Stuba\StructType\HotelElement
     */
    public function addToRating(\Stuba\StructType\RatingElement $item)
    {
        $this->Rating[] = $item;
        return $this;
    }
    /**
     * Get Rank value
     * @return int|null
     */
    public function getRank()
    {
        return $this->Rank;
    }
    /**
     * Set Rank value
     * @param int $rank
     * @return \Stuba\StructType\HotelElement
     */
    public function setRank($rank = null)
    {
        $this->Rank = $rank;
        return $this;
    }
    /**
     * Get Id value
     * @return int|null
     */
    public function getId_1()
    {
        return $this->id;
    }
    /**
     * Set Id value
     * @param int $id
     * @return \Stuba\StructType\HotelElement
     */
    public function setId_1($id_1 = null)
    {
        $this->id = $id_1;
        return $this;
    }
    /**
     * Get Name value
     * @return string|null
     */
    public function getName_1()
    {
        return $this->name;
    }
    /**
     * Set Name value
     * @param string $name
     * @return \Stuba\StructType\HotelElement
     */
    public function setName_1($name_1 = null)
    {
        $this->name = $name_1;
        return $this;
    }
    /**
     * Get Type value
     * @return string|null
     */
    public function getType_1()
    {
        return $this->type;
    }
    /**
     * Set Type value
     * @param string $type
     * @return \Stuba\StructType\HotelElement
     */
    public function setType_1($type_1 = null)
    {
        $this->type = $type_1;
        return $this;
    }
    /**
     * Get Stars value
     * @return int|null
     */
    public function getStars_1()
    {
        return $this->stars;
    }
    /**
     * Set Stars value
     * @param int $stars
     * @return \Stuba\StructType\HotelElement
     */
    public function setStars_1($stars_1 = null)
    {
        $this->stars = $stars_1;
        return $this;
    }
    /**
     * Get MinRate value
     * @return float|null
     */
    public function getMinRate_1()
    {
        return $this->minRate;
    }
    /**
     * Set MinRate value
     * @param float $minRate
     * @return \Stuba\StructType\HotelElement
     */
    public function setMinRate_1($minRate_1 = null)
    {
        $this->minRate = $minRate_1;
        return $this;
    }
    /**
     * Get MaxRate value
     * @return float|null
     */
    public function getMaxRate_1()
    {
        return $this->maxRate;
    }
    /**
     * Set MaxRate value
     * @param float $maxRate
     * @return \Stuba\StructType\HotelElement
     */
    public function setMaxRate_1($maxRate_1 = null)
    {
        $this->maxRate = $maxRate_1;
        return $this;
    }
    /**
     * Get Rank value
     * @return int|null
     */
    public function getRank_1()
    {
        return $this->rank;
    }
    /**
     * Set Rank value
     * @param int $rank
     * @return \Stuba\StructType\HotelElement
     */
    public function setRank_1($rank_1 = null)
    {
        $this->rank = $rank_1;
        return $this;
    }
}
