<?php

namespace Stuba\StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for AvailabilitySearchResult StructType
 * @subpackage Structs
 */
class AvailabilitySearchResult extends ResponseBase
{
    /**
     * The HotelAvailability
     * Meta information extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * @var \Stuba\StructType\HotelAvailabilityElement[]
     */
    public $HotelAvailability;
    /**
     * The SupplierErrors
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \Stuba\StructType\SupplierErrorsElement
     */
    public $SupplierErrors;
    /**
     * The DebugInfo
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \Stuba\StructType\DebugInfoElement
     */
    public $DebugInfo;
    /**
     * Constructor method for AvailabilitySearchResult
     * @uses AvailabilitySearchResult::setHotelAvailability()
     * @uses AvailabilitySearchResult::setSupplierErrors()
     * @uses AvailabilitySearchResult::setDebugInfo()
     * @param \Stuba\StructType\HotelAvailabilityElement[] $hotelAvailability
     * @param \Stuba\StructType\SupplierErrorsElement $supplierErrors
     * @param \Stuba\StructType\DebugInfoElement $debugInfo
     */
    public function __construct(array $hotelAvailability = array(), \Stuba\StructType\SupplierErrorsElement $supplierErrors = null, \Stuba\StructType\DebugInfoElement $debugInfo = null)
    {
        $this
            ->setHotelAvailability($hotelAvailability)
            ->setSupplierErrors($supplierErrors)
            ->setDebugInfo($debugInfo);
    }
    /**
     * Get HotelAvailability value
     * @return \Stuba\StructType\HotelAvailabilityElement[]|null
     */
    public function getHotelAvailability()
    {
        return $this->HotelAvailability;
    }
    /**
     * Set HotelAvailability value
     * @param \Stuba\StructType\HotelAvailabilityElement[] $hotelAvailability
     * @return \Stuba\StructType\AvailabilitySearchResult
     */
    public function setHotelAvailability(array $hotelAvailability = array())
    {
        $this->HotelAvailability = $hotelAvailability;
        return $this;
    }
    /**
     * Add item to HotelAvailability value
     * @throws \InvalidArgumentException
     * @param \Stuba\StructType\HotelAvailabilityElement $item
     * @return \Stuba\StructType\AvailabilitySearchResult
     */
    public function addToHotelAvailability(\Stuba\StructType\HotelAvailabilityElement $item)
    {
        $this->HotelAvailability[] = $item;
        return $this;
    }
    /**
     * Get SupplierErrors value
     * @return \Stuba\StructType\SupplierErrorsElement|null
     */
    public function getSupplierErrors()
    {
        return $this->SupplierErrors;
    }
    /**
     * Set SupplierErrors value
     * @param \Stuba\StructType\SupplierErrorsElement $supplierErrors
     * @return \Stuba\StructType\AvailabilitySearchResult
     */
    public function setSupplierErrors(\Stuba\StructType\SupplierErrorsElement $supplierErrors = null)
    {
        $this->SupplierErrors = $supplierErrors;
        return $this;
    }
    /**
     * Get DebugInfo value
     * @return \Stuba\StructType\DebugInfoElement|null
     */
    public function getDebugInfo()
    {
        return $this->DebugInfo;
    }
    /**
     * Set DebugInfo value
     * @param \Stuba\StructType\DebugInfoElement $debugInfo
     * @return \Stuba\StructType\AvailabilitySearchResult
     */
    public function setDebugInfo(\Stuba\StructType\DebugInfoElement $debugInfo = null)
    {
        $this->DebugInfo = $debugInfo;
        return $this;
    }
}
