<?php

namespace Stuba\ServiceType;

use \WsdlToPhp\PackageBase\AbstractSoapClientBase;

/**
 * This class stands for Hotel ServiceType
 * @subpackage Services
 */
class Hotel extends AbstractSoapClientBase
{
    /**
     * Method to call the operation originally named HotelSearch
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \Stuba\StructType\HotelSearch $parameters
     * @return \Stuba\StructType\HotelSearchResponse|bool
     */
    public function HotelSearch(\Stuba\StructType\HotelSearch $parameters)
    {
        try {
            $this->setResult($this->getSoapClient()->HotelSearch($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Returns the result
     * @see AbstractSoapClientBase::getResult()
     * @return \Stuba\StructType\HotelSearchResponse
     */
    public function getResult()
    {
        return parent::getResult();
    }
}
