<?php

namespace Stuba\StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for InformationElement StructType
 * @subpackage Structs
 */
class InformationElement extends AbstractStructBase
{
    /**
     * The Code
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $Code;
    /**
     * The Text
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $Text;
    /**
     * The Value
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $Value;
    /**
     * Constructor method for InformationElement
     * @uses InformationElement::setCode()
     * @uses InformationElement::setText()
     * @uses InformationElement::setValue()
     * @param string $code
     * @param string $text
     * @param string $value
     */
    public function __construct($code = null, $text = null, $value = null)
    {
        $this
            ->setCode($code)
            ->setText($text)
            ->setValue($value);
    }
    /**
     * Get Code value
     * @return string|null
     */
    public function getCode()
    {
        return $this->Code;
    }
    /**
     * Set Code value
     * @param string $code
     * @return \Stuba\StructType\InformationElement
     */
    public function setCode($code = null)
    {
        $this->Code = $code;
        return $this;
    }
    /**
     * Get Text value
     * @return string|null
     */
    public function getText()
    {
        return $this->Text;
    }
    /**
     * Set Text value
     * @param string $text
     * @return \Stuba\StructType\InformationElement
     */
    public function setText($text = null)
    {
        $this->Text = $text;
        return $this;
    }
    /**
     * Get Value value
     * @return string|null
     */
    public function getValue()
    {
        return $this->Value;
    }
    /**
     * Set Value value
     * @param string $value
     * @return \Stuba\StructType\InformationElement
     */
    public function setValue($value = null)
    {
        $this->Value = $value;
        return $this;
    }
}
