<?php

namespace Stuba\ServiceType;

use \WsdlToPhp\PackageBase\AbstractSoapClientBase;

/**
 * This class stands for Refresh ServiceType
 * @subpackage Services
 */
class Refresh extends AbstractSoapClientBase
{
    /**
     * Method to call the operation originally named RefreshHotel
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \Stuba\StructType\RefreshHotel $parameters
     * @return \Stuba\StructType\RefreshHotelResponse|bool
     */
    public function RefreshHotel(\Stuba\StructType\RefreshHotel $parameters)
    {
        try {
            $this->setResult($this->getSoapClient()->RefreshHotel($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Returns the result
     * @see AbstractSoapClientBase::getResult()
     * @return \Stuba\StructType\RefreshHotelResponse
     */
    public function getResult()
    {
        return parent::getResult();
    }
}
