<?php

namespace Stuba\StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for TransferAvailabilitySearch StructType
 * @subpackage Structs
 */
class TransferAvailabilitySearch extends AbstractStructBase
{
    /**
     * The PickupPoint
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var int
     */
    public $PickupPoint;
    /**
     * The DestinationPoint
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var int
     */
    public $DestinationPoint;
    /**
     * The TransferDirection
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var string
     */
    public $TransferDirection;
    /**
     * The xiRequest
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \Stuba\StructType\TransferAvailabilitySearch
     */
    public $xiRequest;
    /**
     * The Authority
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \Stuba\StructType\AuthorityElement
     */
    public $Authority;
    /**
     * The OutboundDateTime
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $OutboundDateTime;
    /**
     * The InboundDateTime
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $InboundDateTime;
    /**
     * The Guests
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \Stuba\StructType\ArrayOfChoice3
     */
    public $Guests;
    /**
     * Constructor method for TransferAvailabilitySearch
     * @uses TransferAvailabilitySearch::setPickupPoint()
     * @uses TransferAvailabilitySearch::setDestinationPoint()
     * @uses TransferAvailabilitySearch::setTransferDirection()
     * @uses TransferAvailabilitySearch::setXiRequest()
     * @uses TransferAvailabilitySearch::setAuthority()
     * @uses TransferAvailabilitySearch::setOutboundDateTime()
     * @uses TransferAvailabilitySearch::setInboundDateTime()
     * @uses TransferAvailabilitySearch::setGuests()
     * @param int $pickupPoint
     * @param int $destinationPoint
     * @param string $transferDirection
     * @param \Stuba\StructType\TransferAvailabilitySearch $xiRequest
     * @param \Stuba\StructType\AuthorityElement $authority
     * @param string $outboundDateTime
     * @param string $inboundDateTime
     * @param \Stuba\StructType\ArrayOfChoice3 $guests
     */
    public function __construct($pickupPoint = null, $destinationPoint = null, $transferDirection = null, \Stuba\StructType\TransferAvailabilitySearch $xiRequest = null, \Stuba\StructType\AuthorityElement $authority = null, $outboundDateTime = null, $inboundDateTime = null, \Stuba\StructType\ArrayOfChoice3 $guests = null)
    {
        $this
            ->setPickupPoint($pickupPoint)
            ->setDestinationPoint($destinationPoint)
            ->setTransferDirection($transferDirection)
            ->setXiRequest($xiRequest)
            ->setAuthority($authority)
            ->setOutboundDateTime($outboundDateTime)
            ->setInboundDateTime($inboundDateTime)
            ->setGuests($guests);
    }
    /**
     * Get PickupPoint value
     * @return int
     */
    public function getPickupPoint()
    {
        return $this->PickupPoint;
    }
    /**
     * Set PickupPoint value
     * @param int $pickupPoint
     * @return \Stuba\StructType\TransferAvailabilitySearch
     */
    public function setPickupPoint($pickupPoint = null)
    {
        $this->PickupPoint = $pickupPoint;
        return $this;
    }
    /**
     * Get DestinationPoint value
     * @return int
     */
    public function getDestinationPoint()
    {
        return $this->DestinationPoint;
    }
    /**
     * Set DestinationPoint value
     * @param int $destinationPoint
     * @return \Stuba\StructType\TransferAvailabilitySearch
     */
    public function setDestinationPoint($destinationPoint = null)
    {
        $this->DestinationPoint = $destinationPoint;
        return $this;
    }
    /**
     * Get TransferDirection value
     * @return string
     */
    public function getTransferDirection()
    {
        return $this->TransferDirection;
    }
    /**
     * Set TransferDirection value
     * @param string $transferDirection
     * @return \Stuba\StructType\TransferAvailabilitySearch
     */
    public function setTransferDirection($transferDirection = null)
    {
        $this->TransferDirection = $transferDirection;
        return $this;
    }
    /**
     * Get xiRequest value
     * @return \Stuba\StructType\TransferAvailabilitySearch|null
     */
    public function getXiRequest()
    {
        return $this->xiRequest;
    }
    /**
     * Set xiRequest value
     * @param \Stuba\StructType\TransferAvailabilitySearch $xiRequest
     * @return \Stuba\StructType\TransferAvailabilitySearch
     */
    public function setXiRequest(\Stuba\StructType\TransferAvailabilitySearch $xiRequest = null)
    {
        $this->xiRequest = $xiRequest;
        return $this;
    }
    /**
     * Get Authority value
     * @return \Stuba\StructType\AuthorityElement|null
     */
    public function getAuthority()
    {
        return $this->Authority;
    }
    /**
     * Set Authority value
     * @param \Stuba\StructType\AuthorityElement $authority
     * @return \Stuba\StructType\TransferAvailabilitySearch
     */
    public function setAuthority(\Stuba\StructType\AuthorityElement $authority = null)
    {
        $this->Authority = $authority;
        return $this;
    }
    /**
     * Get OutboundDateTime value
     * @return string|null
     */
    public function getOutboundDateTime()
    {
        return $this->OutboundDateTime;
    }
    /**
     * Set OutboundDateTime value
     * @param string $outboundDateTime
     * @return \Stuba\StructType\TransferAvailabilitySearch
     */
    public function setOutboundDateTime($outboundDateTime = null)
    {
        $this->OutboundDateTime = $outboundDateTime;
        return $this;
    }
    /**
     * Get InboundDateTime value
     * @return string|null
     */
    public function getInboundDateTime()
    {
        return $this->InboundDateTime;
    }
    /**
     * Set InboundDateTime value
     * @param string $inboundDateTime
     * @return \Stuba\StructType\TransferAvailabilitySearch
     */
    public function setInboundDateTime($inboundDateTime = null)
    {
        $this->InboundDateTime = $inboundDateTime;
        return $this;
    }
    /**
     * Get Guests value
     * @return \Stuba\StructType\ArrayOfChoice3|null
     */
    public function getGuests()
    {
        return $this->Guests;
    }
    /**
     * Set Guests value
     * @param \Stuba\StructType\ArrayOfChoice3 $guests
     * @return \Stuba\StructType\TransferAvailabilitySearch
     */
    public function setGuests(\Stuba\StructType\ArrayOfChoice3 $guests = null)
    {
        $this->Guests = $guests;
        return $this;
    }
}
