<?php

namespace Stuba\StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for TransferAvailabilityElement StructType
 * @subpackage Structs
 */
class TransferAvailabilityElement extends AbstractStructBase
{
    /**
     * The PickupPoint
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var int
     */
    public $PickupPoint;
    /**
     * The DestinationPoint
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var int
     */
    public $DestinationPoint;
    /**
     * The Result
     * Meta information extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * @var \Stuba\StructType\TransferAvailabilityResultElement[]
     */
    public $Result;
    /**
     * Constructor method for TransferAvailabilityElement
     * @uses TransferAvailabilityElement::setPickupPoint()
     * @uses TransferAvailabilityElement::setDestinationPoint()
     * @uses TransferAvailabilityElement::setResult()
     * @param int $pickupPoint
     * @param int $destinationPoint
     * @param \Stuba\StructType\TransferAvailabilityResultElement[] $result
     */
    public function __construct($pickupPoint = null, $destinationPoint = null, array $result = array())
    {
        $this
            ->setPickupPoint($pickupPoint)
            ->setDestinationPoint($destinationPoint)
            ->setResult($result);
    }
    /**
     * Get PickupPoint value
     * @return int
     */
    public function getPickupPoint()
    {
        return $this->PickupPoint;
    }
    /**
     * Set PickupPoint value
     * @param int $pickupPoint
     * @return \Stuba\StructType\TransferAvailabilityElement
     */
    public function setPickupPoint($pickupPoint = null)
    {
        $this->PickupPoint = $pickupPoint;
        return $this;
    }
    /**
     * Get DestinationPoint value
     * @return int
     */
    public function getDestinationPoint()
    {
        return $this->DestinationPoint;
    }
    /**
     * Set DestinationPoint value
     * @param int $destinationPoint
     * @return \Stuba\StructType\TransferAvailabilityElement
     */
    public function setDestinationPoint($destinationPoint = null)
    {
        $this->DestinationPoint = $destinationPoint;
        return $this;
    }
    /**
     * Get Result value
     * @return \Stuba\StructType\TransferAvailabilityResultElement[]|null
     */
    public function getResult()
    {
        return $this->Result;
    }
    /**
     * Set Result value
     * @param \Stuba\StructType\TransferAvailabilityResultElement[] $result
     * @return \Stuba\StructType\TransferAvailabilityElement
     */
    public function setResult(array $result = array())
    {
        $this->Result = $result;
        return $this;
    }
    /**
     * Add item to Result value
     * @throws \InvalidArgumentException
     * @param \Stuba\StructType\TransferAvailabilityResultElement $item
     * @return \Stuba\StructType\TransferAvailabilityElement
     */
    public function addToResult(\Stuba\StructType\TransferAvailabilityResultElement $item)
    {
        $this->Result[] = $item;
        return $this;
    }
}
