<?php

namespace Stuba\StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for HotelAvailabilityElement StructType
 * @subpackage Structs
 */
class HotelAvailabilityElement extends AbstractStructBase
{
    /**
     * The Hotel
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \Stuba\StructType\HotelElement
     */
    public $Hotel;
    /**
     * The Result
     * Meta information extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * @var \Stuba\StructType\HotelAvailabilityResultElement[]
     */
    public $Result;
    /**
     * The hotelQuoteId
     * @var string
     */
    public $hotelQuoteId;
    /**
     * Constructor method for HotelAvailabilityElement
     * @uses HotelAvailabilityElement::setHotel()
     * @uses HotelAvailabilityElement::setResult()
     * @uses HotelAvailabilityElement::setHotelQuoteId()
     * @param \Stuba\StructType\HotelElement $hotel
     * @param \Stuba\StructType\HotelAvailabilityResultElement[] $result
     * @param string $hotelQuoteId
     */
    public function __construct(\Stuba\StructType\HotelElement $hotel = null, array $result = array(), $hotelQuoteId = null)
    {
        $this
            ->setHotel($hotel)
            ->setResult($result)
            ->setHotelQuoteId($hotelQuoteId);
    }
    /**
     * Get Hotel value
     * @return \Stuba\StructType\HotelElement|null
     */
    public function getHotel()
    {
        return $this->Hotel;
    }
    /**
     * Set Hotel value
     * @param \Stuba\StructType\HotelElement $hotel
     * @return \Stuba\StructType\HotelAvailabilityElement
     */
    public function setHotel(\Stuba\StructType\HotelElement $hotel = null)
    {
        $this->Hotel = $hotel;
        return $this;
    }
    /**
     * Get Result value
     * @return \Stuba\StructType\HotelAvailabilityResultElement[]|null
     */
    public function getResult()
    {
        return $this->Result;
    }
    /**
     * Set Result value
     * @param \Stuba\StructType\HotelAvailabilityResultElement[] $result
     * @return \Stuba\StructType\HotelAvailabilityElement
     */
    public function setResult(array $result = array())
    {
        $this->Result = $result;
        return $this;
    }
    /**
     * Add item to Result value
     * @throws \InvalidArgumentException
     * @param \Stuba\StructType\HotelAvailabilityResultElement $item
     * @return \Stuba\StructType\HotelAvailabilityElement
     */
    public function addToResult(\Stuba\StructType\HotelAvailabilityResultElement $item)
    {
        $this->Result[] = $item;
        return $this;
    }
    /**
     * Get hotelQuoteId value
     * @return string|null
     */
    public function getHotelQuoteId()
    {
        return $this->hotelQuoteId;
    }
    /**
     * Set hotelQuoteId value
     * @param string $hotelQuoteId
     * @return \Stuba\StructType\HotelAvailabilityElement
     */
    public function setHotelQuoteId($hotelQuoteId = null)
    {
        $this->hotelQuoteId = $hotelQuoteId;
        return $this;
    }
}
