<?php

namespace Stuba\StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for BookingQueryResult StructType
 * @subpackage Structs
 */
class BookingQueryResult extends ResponseBase
{
    /**
     * The Booking
     * Meta information extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * @var \Stuba\StructType\BookingElement[]
     */
    public $Booking;
    /**
     * Constructor method for BookingQueryResult
     * @uses BookingQueryResult::setBooking()
     * @param \Stuba\StructType\BookingElement[] $booking
     */
    public function __construct(array $booking = array())
    {
        $this
            ->setBooking($booking);
    }
    /**
     * Get Booking value
     * @return \Stuba\StructType\BookingElement[]|null
     */
    public function getBooking()
    {
        return $this->Booking;
    }
    /**
     * Set Booking value
     * @param \Stuba\StructType\BookingElement[] $booking
     * @return \Stuba\StructType\BookingQueryResult
     */
    public function setBooking(array $booking = array())
    {
        $this->Booking = $booking;
        return $this;
    }
    /**
     * Add item to Booking value
     * @throws \InvalidArgumentException
     * @param \Stuba\StructType\BookingElement $item
     * @return \Stuba\StructType\BookingQueryResult
     */
    public function addToBooking(\Stuba\StructType\BookingElement $item)
    {
        $this->Booking[] = $item;
        return $this;
    }
}
