<?php

namespace Stuba\StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for BookingElement StructType
 * @subpackage Structs
 */
class BookingElement extends AbstractStructBase
{
    /**
     * The CreationDate
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var string
     */
    public $CreationDate;
    /**
     * The Id
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var int
     */
    public $Id;
    /**
     * The Customer
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \Stuba\StructType\CustomerElement
     */
    public $Customer;
    /**
     * The Affiliate
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $Affiliate;
    /**
     * The AgentReference
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $AgentReference;
    /**
     * The OperatorReference
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $OperatorReference;
    /**
     * The HotelBooking
     * Meta information extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * @var \Stuba\StructType\HotelBookingElement[]
     */
    public $HotelBooking;
    /**
     * The TransferBooking
     * Meta information extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * @var \Stuba\StructType\TransferBookingElement[]
     */
    public $TransferBooking;
    /**
     * The Payment
     * Meta information extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * @var \Stuba\StructType\PaymentElement[]
     */
    public $Payment;
    /**
     * The Charge
     * Meta information extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * @var \Stuba\StructType\ChargeElement[]
     */
    public $Charge;
    /**
     * Constructor method for BookingElement
     * @uses BookingElement::setCreationDate()
     * @uses BookingElement::setId()
     * @uses BookingElement::setCustomer()
     * @uses BookingElement::setAffiliate()
     * @uses BookingElement::setAgentReference()
     * @uses BookingElement::setOperatorReference()
     * @uses BookingElement::setHotelBooking()
     * @uses BookingElement::setTransferBooking()
     * @uses BookingElement::setPayment()
     * @uses BookingElement::setCharge()
     * @param string $creationDate
     * @param int $id
     * @param \Stuba\StructType\CustomerElement $customer
     * @param string $affiliate
     * @param string $agentReference
     * @param string $operatorReference
     * @param \Stuba\StructType\HotelBookingElement[] $hotelBooking
     * @param \Stuba\StructType\TransferBookingElement[] $transferBooking
     * @param \Stuba\StructType\PaymentElement[] $payment
     * @param \Stuba\StructType\ChargeElement[] $charge
     */
    public function __construct($creationDate = null, $id = null, \Stuba\StructType\CustomerElement $customer = null, $affiliate = null, $agentReference = null, $operatorReference = null, array $hotelBooking = array(), array $transferBooking = array(), array $payment = array(), array $charge = array())
    {
        $this
            ->setCreationDate($creationDate)
            ->setId($id)
            ->setCustomer($customer)
            ->setAffiliate($affiliate)
            ->setAgentReference($agentReference)
            ->setOperatorReference($operatorReference)
            ->setHotelBooking($hotelBooking)
            ->setTransferBooking($transferBooking)
            ->setPayment($payment)
            ->setCharge($charge);
    }
    /**
     * Get CreationDate value
     * @return string
     */
    public function getCreationDate()
    {
        return $this->CreationDate;
    }
    /**
     * Set CreationDate value
     * @param string $creationDate
     * @return \Stuba\StructType\BookingElement
     */
    public function setCreationDate($creationDate = null)
    {
        $this->CreationDate = $creationDate;
        return $this;
    }
    /**
     * Get Id value
     * @return int|null
     */
    public function getId()
    {
        return $this->Id;
    }
    /**
     * Set Id value
     * @param int $id
     * @return \Stuba\StructType\BookingElement
     */
    public function setId($id = null)
    {
        $this->Id = $id;
        return $this;
    }
    /**
     * Get Customer value
     * @return \Stuba\StructType\CustomerElement|null
     */
    public function getCustomer()
    {
        return $this->Customer;
    }
    /**
     * Set Customer value
     * @param \Stuba\StructType\CustomerElement $customer
     * @return \Stuba\StructType\BookingElement
     */
    public function setCustomer(\Stuba\StructType\CustomerElement $customer = null)
    {
        $this->Customer = $customer;
        return $this;
    }
    /**
     * Get Affiliate value
     * @return string|null
     */
    public function getAffiliate()
    {
        return $this->Affiliate;
    }
    /**
     * Set Affiliate value
     * @param string $affiliate
     * @return \Stuba\StructType\BookingElement
     */
    public function setAffiliate($affiliate = null)
    {
        $this->Affiliate = $affiliate;
        return $this;
    }
    /**
     * Get AgentReference value
     * @return string|null
     */
    public function getAgentReference()
    {
        return $this->AgentReference;
    }
    /**
     * Set AgentReference value
     * @param string $agentReference
     * @return \Stuba\StructType\BookingElement
     */
    public function setAgentReference($agentReference = null)
    {
        $this->AgentReference = $agentReference;
        return $this;
    }
    /**
     * Get OperatorReference value
     * @return string|null
     */
    public function getOperatorReference()
    {
        return $this->OperatorReference;
    }
    /**
     * Set OperatorReference value
     * @param string $operatorReference
     * @return \Stuba\StructType\BookingElement
     */
    public function setOperatorReference($operatorReference = null)
    {
        $this->OperatorReference = $operatorReference;
        return $this;
    }
    /**
     * Get HotelBooking value
     * @return \Stuba\StructType\HotelBookingElement[]|null
     */
    public function getHotelBooking()
    {
        return $this->HotelBooking;
    }
    /**
     * Set HotelBooking value
     * @param \Stuba\StructType\HotelBookingElement[] $hotelBooking
     * @return \Stuba\StructType\BookingElement
     */
    public function setHotelBooking(array $hotelBooking = array())
    {
        $this->HotelBooking = $hotelBooking;
        return $this;
    }
    /**
     * Add item to HotelBooking value
     * @throws \InvalidArgumentException
     * @param \Stuba\StructType\HotelBookingElement $item
     * @return \Stuba\StructType\BookingElement
     */
    public function addToHotelBooking(\Stuba\StructType\HotelBookingElement $item)
    {
        $this->HotelBooking[] = $item;
        return $this;
    }
    /**
     * Get TransferBooking value
     * @return \Stuba\StructType\TransferBookingElement[]|null
     */
    public function getTransferBooking()
    {
        return $this->TransferBooking;
    }
    /**
     * Set TransferBooking value
     * @param \Stuba\StructType\TransferBookingElement[] $transferBooking
     * @return \Stuba\StructType\BookingElement
     */
    public function setTransferBooking(array $transferBooking = array())
    {
        $this->TransferBooking = $transferBooking;
        return $this;
    }
    /**
     * Add item to TransferBooking value
     * @throws \InvalidArgumentException
     * @param \Stuba\StructType\TransferBookingElement $item
     * @return \Stuba\StructType\BookingElement
     */
    public function addToTransferBooking(\Stuba\StructType\TransferBookingElement $item)
    {
        $this->TransferBooking[] = $item;
        return $this;
    }
    /**
     * Get Payment value
     * @return \Stuba\StructType\PaymentElement[]|null
     */
    public function getPayment()
    {
        return $this->Payment;
    }
    /**
     * Set Payment value
     * @param \Stuba\StructType\PaymentElement[] $payment
     * @return \Stuba\StructType\BookingElement
     */
    public function setPayment(array $payment = array())
    {
        $this->Payment = $payment;
        return $this;
    }
    /**
     * Add item to Payment value
     * @throws \InvalidArgumentException
     * @param \Stuba\StructType\PaymentElement $item
     * @return \Stuba\StructType\BookingElement
     */
    public function addToPayment(\Stuba\StructType\PaymentElement $item)
    {
        $this->Payment[] = $item;
        return $this;
    }
    /**
     * Get Charge value
     * @return \Stuba\StructType\ChargeElement[]|null
     */
    public function getCharge()
    {
        return $this->Charge;
    }
    /**
     * Set Charge value
     * @param \Stuba\StructType\ChargeElement[] $charge
     * @return \Stuba\StructType\BookingElement
     */
    public function setCharge(array $charge = array())
    {
        $this->Charge = $charge;
        return $this;
    }
    /**
     * Add item to Charge value
     * @throws \InvalidArgumentException
     * @param \Stuba\StructType\ChargeElement $item
     * @return \Stuba\StructType\BookingElement
     */
    public function addToCharge(\Stuba\StructType\ChargeElement $item)
    {
        $this->Charge[] = $item;
        return $this;
    }
}
