<?php

namespace Stuba\ServiceType;

use \WsdlToPhp\PackageBase\AbstractSoapClientBase;

/**
 * This class stands for Transfer ServiceType
 * @subpackage Services
 */
class Transfer extends AbstractSoapClientBase
{
    /**
     * Method to call the operation originally named TransferAvailabilitySearch
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \Stuba\StructType\TransferAvailabilitySearch $parameters
     * @return \Stuba\StructType\TransferAvailabilitySearchResponse|bool
     */
    public function TransferAvailabilitySearch(\Stuba\StructType\TransferAvailabilitySearch $parameters)
    {
        try {
            $this->setResult($this->getSoapClient()->TransferAvailabilitySearch($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named TransferEndPointSearch
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \Stuba\StructType\TransferEndPointSearch $parameters
     * @return \Stuba\StructType\TransferEndPointSearchResponse|bool
     */
    public function TransferEndPointSearch(\Stuba\StructType\TransferEndPointSearch $parameters)
    {
        try {
            $this->setResult($this->getSoapClient()->TransferEndPointSearch($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named TransferRouteSearch
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \Stuba\StructType\TransferRouteSearch $parameters
     * @return \Stuba\StructType\TransferRouteSearchResponse|bool
     */
    public function TransferRouteSearch(\Stuba\StructType\TransferRouteSearch $parameters)
    {
        try {
            $this->setResult($this->getSoapClient()->TransferRouteSearch($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Returns the result
     * @see AbstractSoapClientBase::getResult()
     * @return \Stuba\StructType\TransferAvailabilitySearchResponse|\Stuba\StructType\TransferEndPointSearchResponse|\Stuba\StructType\TransferRouteSearchResponse
     */
    public function getResult()
    {
        return parent::getResult();
    }
}
