<?php

namespace Stuba\StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for PaymentDetailsElement StructType
 * @subpackage Structs
 */
class PaymentDetailsElement extends AbstractStructBase
{
    /**
     * The PaymentType
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \Stuba\StructType\TextEnumPair
     */
    public $PaymentType;
    /**
     * The CreditCard
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \Stuba\StructType\CreditCardElement
     */
    public $CreditCard;
    /**
     * Constructor method for PaymentDetailsElement
     * @uses PaymentDetailsElement::setPaymentType()
     * @uses PaymentDetailsElement::setCreditCard()
     * @param \Stuba\StructType\TextEnumPair $paymentType
     * @param \Stuba\StructType\CreditCardElement $creditCard
     */
    public function __construct(\Stuba\StructType\TextEnumPair $paymentType = null, \Stuba\StructType\CreditCardElement $creditCard = null)
    {
        $this
            ->setPaymentType($paymentType)
            ->setCreditCard($creditCard);
    }
    /**
     * Get PaymentType value
     * @return \Stuba\StructType\TextEnumPair|null
     */
    public function getPaymentType()
    {
        return $this->PaymentType;
    }
    /**
     * Set PaymentType value
     * @param \Stuba\StructType\TextEnumPair $paymentType
     * @return \Stuba\StructType\PaymentDetailsElement
     */
    public function setPaymentType(\Stuba\StructType\TextEnumPair $paymentType = null)
    {
        $this->PaymentType = $paymentType;
        return $this;
    }
    /**
     * Get CreditCard value
     * @return \Stuba\StructType\CreditCardElement|null
     */
    public function getCreditCard()
    {
        return $this->CreditCard;
    }
    /**
     * Set CreditCard value
     * @param \Stuba\StructType\CreditCardElement $creditCard
     * @return \Stuba\StructType\PaymentDetailsElement
     */
    public function setCreditCard(\Stuba\StructType\CreditCardElement $creditCard = null)
    {
        $this->CreditCard = $creditCard;
        return $this;
    }
}
