<?php

namespace Stuba\StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for CreditCardElement StructType
 * @subpackage Structs
 */
class CreditCardElement extends AbstractStructBase
{
    /**
     * The StartDate
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var string
     */
    public $StartDate;
    /**
     * The EndDate
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var string
     */
    public $EndDate;
    /**
     * The IssueNumber
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var int
     */
    public $IssueNumber;
    /**
     * The CardNumber
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $CardNumber;
    /**
     * The SecurityCode
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $SecurityCode;
    /**
     * Constructor method for CreditCardElement
     * @uses CreditCardElement::setStartDate()
     * @uses CreditCardElement::setEndDate()
     * @uses CreditCardElement::setIssueNumber()
     * @uses CreditCardElement::setCardNumber()
     * @uses CreditCardElement::setSecurityCode()
     * @param string $startDate
     * @param string $endDate
     * @param int $issueNumber
     * @param string $cardNumber
     * @param string $securityCode
     */
    public function __construct($startDate = null, $endDate = null, $issueNumber = null, $cardNumber = null, $securityCode = null)
    {
        $this
            ->setStartDate($startDate)
            ->setEndDate($endDate)
            ->setIssueNumber($issueNumber)
            ->setCardNumber($cardNumber)
            ->setSecurityCode($securityCode);
    }
    /**
     * Get StartDate value
     * @return string
     */
    public function getStartDate()
    {
        return $this->StartDate;
    }
    /**
     * Set StartDate value
     * @param string $startDate
     * @return \Stuba\StructType\CreditCardElement
     */
    public function setStartDate($startDate = null)
    {
        $this->StartDate = $startDate;
        return $this;
    }
    /**
     * Get EndDate value
     * @return string
     */
    public function getEndDate()
    {
        return $this->EndDate;
    }
    /**
     * Set EndDate value
     * @param string $endDate
     * @return \Stuba\StructType\CreditCardElement
     */
    public function setEndDate($endDate = null)
    {
        $this->EndDate = $endDate;
        return $this;
    }
    /**
     * Get IssueNumber value
     * @return int
     */
    public function getIssueNumber()
    {
        return $this->IssueNumber;
    }
    /**
     * Set IssueNumber value
     * @param int $issueNumber
     * @return \Stuba\StructType\CreditCardElement
     */
    public function setIssueNumber($issueNumber = null)
    {
        $this->IssueNumber = $issueNumber;
        return $this;
    }
    /**
     * Get CardNumber value
     * @return string|null
     */
    public function getCardNumber()
    {
        return $this->CardNumber;
    }
    /**
     * Set CardNumber value
     * @param string $cardNumber
     * @return \Stuba\StructType\CreditCardElement
     */
    public function setCardNumber($cardNumber = null)
    {
        $this->CardNumber = $cardNumber;
        return $this;
    }
    /**
     * Get SecurityCode value
     * @return string|null
     */
    public function getSecurityCode()
    {
        return $this->SecurityCode;
    }
    /**
     * Set SecurityCode value
     * @param string $securityCode
     * @return \Stuba\StructType\CreditCardElement
     */
    public function setSecurityCode($securityCode = null)
    {
        $this->SecurityCode = $securityCode;
        return $this;
    }
}
